/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          spm_SystemLoadStatistics.h
  * @PROJECT:      CMD project
  * @brief         include header file
  *
  * ----------------------------------------------------------------------------
  * @copyright     (C) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_ISystemLoadStatistics.h"
#include "spm_ISuperVisionClient.h"
#include "spm_IStartupSupervisor.h"

/*!
  *  \class spm_tclSystemLoadStatistics
  *  \brief This class implements the generic system load statistics data collecting.
  *         The template typename T is a data pool class to help keeping data.
  *         The method bUpdateLoading() is for keeping the value and update max/avg/min values.
  *
  */
template < typename T >
class spm_tclSystemLoadStatistics : public ISpmSystemLoadStatistics
{
public:
spm_tclSystemLoadStatistics( const ISpmFactory& factory, enSystemLoadStatisticsType eSysLoadType, enStatisticsType eStatType );
virtual ~spm_tclSystemLoadStatistics( );

virtual tVoid vSetNewData( tU32 u32StatisticType ) const;

virtual tVoid vGetData( void *pStatistics,
                        tU32  u32ObjectSize ) const; //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

virtual tVoid vErase( ) const {};

virtual tVoid vTrace( ) const;

// implementation of functions needed for other statitics
virtual tBool bChkUnknownReset( tU32 /*u32StatisticType*/ ) const { return( FALSE ); } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual tVoid vGetLastReset( TSpmResetElem*/*pLastResetData*/ ) const { }            //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual std::string szAsString( ) const { return( "" ); }
virtual tVoid vUpdateResetCounter( tVoid ) const {}

// trace handling
virtual tVoid vHandleTraceMessage( const tUChar*/*puchData*/ ){ } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

virtual tVoid bUpdateLoading( tU32 u32Load );

virtual tVoid vEraseLoading( );

protected:
// ISpmBase interface functions
virtual tVoid vGetReferences( );
virtual tVoid vStartCommunication( );

virtual const tChar*getName( ) const { return( "spm_tclSystemLoadStatistics" ); }

private:
enSystemLoadStatisticsType             _eSysLoadType;
TSpmSystemLoadStatisticsData           _tSystemLoadStatisticsData;
ISpmSystemLoadStatistics               *_poSystemLoadStatistics;
ISpmSupervisionClient                  *_poSpmSupervisionClient;
};

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"
/*!
  *  \class spm_tclCpuUsageStatistics
  *  \brief This class is for collecting the CPU load of system with Max/Avg/Min values.
  *         The bUpdateLoading( ) will be called periodically in the CpuLoadSupervisor vCheckSupervisionState.
  *
  */
class spm_tclCpuUsageStatistics : public spm_tclSystemLoadStatistics< dp_tclSpmDpEngDataCpuUsageStatistics >
{
public:
spm_tclCpuUsageStatistics( const ISpmFactory& factory );
// trace handling
virtual tVoid vHandleTraceMessage( const tUChar* puchData );
virtual const tChar*getName( ) const { return(   "spm_tclCpuUsageStatistics" ); }

};
/*!
  *  \class spm_tclSWVersionCpuUsageStatistics
  *  \brief This class is for collecting the CPU load of system with Max/Avg/Min values.
  *         The bUpdateLoading( ) will be called periodically in the CpuLoadSupervisor vCheckSupervisionState.
  *
  */
class spm_tclSWVersionCpuUsageStatistics : public spm_tclSystemLoadStatistics< dp_tclSpmDpEngDataCurrentSWVersionCpuUsageStatistics >
{
public:
spm_tclSWVersionCpuUsageStatistics( const ISpmFactory& factory );
// trace handling
virtual tVoid vHandleTraceMessage( const tUChar* /*puchData*/ ){ }
virtual const tChar*getName( ) const { return(   "spm_tclSWVersionCpuUsageStatistics" ); }

};

/*!
  *  \class spm_tclRamUsageStatistics
  *  \brief This class is for collecting the RAM load of system with Max/Avg/Min values.
  *         The bUpdateLoading( ) will be called periodically in the RamLoadSupervisor vCheckSupervisionState.
  *
  */
class spm_tclRamUsageStatistics : public spm_tclSystemLoadStatistics< dp_tclSpmDpEngDataRamUsageStatistics >
{
public:
spm_tclRamUsageStatistics( const ISpmFactory& factory );
// trace handling
virtual tVoid vHandleTraceMessage( const tUChar* puchData );
virtual const tChar*getName( ) const { return( "spm_tclRamUsageStatistics" ); }

};

/*!
  *  \class spm_tclSWVersionRamUsageStatistics
  *  \brief This class is for collecting the RAM load of system with Max/Avg/Min values.
  *         The bUpdateLoading( ) will be called periodically in the RamLoadSupervisor vCheckSupervisionState.
  *
  */
class spm_tclSWVersionRamUsageStatistics : public spm_tclSystemLoadStatistics< dp_tclSpmDpEngDataCurrentSWVersionRamUsageStatistics >
{
public:
spm_tclSWVersionRamUsageStatistics( const ISpmFactory& factory );
// trace handling
virtual tVoid vHandleTraceMessage( const tUChar* /*puchData*/ ){ }
virtual const tChar*getName( ) const { return( "spm_tclSWVersionRamUsageStatistics" ); }

};

/*!
  *  \class spm_tclStartupTimeStatistics
  *  \brief This class is for collecting the start-up time of system with Max/Avg/Min values.
  *         The bUpdateLoading( ) will be called in the StartupSupervisor vCheckSupervisionState.
  */
class spm_tclStartupTimeStatistics : public spm_tclSystemLoadStatistics< dp_tclSpmDpEngDataStartupTimeStatistics >
{
public:
spm_tclStartupTimeStatistics( const ISpmFactory& factory );
// trace handling
virtual tVoid vHandleTraceMessage( const tUChar* puchData );
virtual const tChar*getName( ) const { return(  "spm_tclStartupTimeStatistics"  ); }

};

/*!
  *  \class spm_tclSWVersionStartupTimeStatistics
  *  \brief This class is for collecting the start-up time of system with Max/Avg/Min values.
  *         The bUpdateLoading( ) will be called in the StartupSupervisor vCheckSupervisionState.
  */
class spm_tclSWVersionStartupTimeStatistics : public spm_tclSystemLoadStatistics< dp_tclSpmDpEngDataCurrentSWVersionStartupTimeStatistics >
{
public:
spm_tclSWVersionStartupTimeStatistics( const ISpmFactory& factory );
// trace handling
virtual tVoid vHandleTraceMessage( const tUChar* /*puchData*/ ){ }
virtual const tChar*getName( ) const { return(  "spm_tclSWVersionStartupTimeStatistics"  ); }

};
