/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_SwitchOnStatistics.h
  * @brief        This is header file contains functions related to Wakeup statistics of system.
  * @copyright    (C) 2013 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_IStatistics.h"

/*!
  *  \class spm_tclSwitchOnStatisticsTemplate
  *  \brief This class is for Wakeup statistics of system. The template type
  *         T1: SwitchOnHistory data pool of TSpmSwitchOnStatisticsData type history for the reasons switch on the device.
  *         T2: DeviceOnCount data pool contains counter of how often the device was turned UserOn.
  */
template < typename T1, typename T2 >
class spm_tclSwitchOnStatisticsTemplate : public ISpmStatistics
{
public:
spm_tclSwitchOnStatisticsTemplate( const ISpmFactory& factory, enStatisticsType eStatType );
virtual ~spm_tclSwitchOnStatisticsTemplate( );

virtual tVoid vSetNewData( tU32 u32StatisticType ) const;

virtual tVoid vGetData( void *pStatistics,
                        tU32 u32ObjectSize = 0 ) const;

virtual tVoid vErase( ) const;

virtual tVoid vTrace( ) const;

// implementation of functions needed for other statitics
virtual tBool bChkUnknownReset( tU32 /*u32StatisticType*/ ) const { return( FALSE ); } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual tVoid vGetLastReset( TSpmResetElem */*pLastResetData*/ ) const { }             //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual std::string szAsString( ) const { return( "" ); }
virtual tVoid vUpdateResetCounter( tVoid ) const {}

// trace handling
virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){ } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

protected:
// ISpmBase interface functions
virtual tVoid vGetReferences( ){ }
virtual tVoid vStartCommunication( ){ }
virtual const tChar*getName( ) const { return( "spm_tclSwitchOnStatisticsTemplate" ); }

};

/*!
  *  \class spm_tclSwitchOnStatistics
  *  \brief This class works for Wakeup statistics of system.
          It uses class dp_tclSpmDpEngDataWupHistory to set , erase and trace statistics data.

        This is used by class spm_tclSystemStateManager for setting Wakeup data.

          The spm_tclFactory object creates an instance of this class.
  */

class spm_tclSwitchOnStatistics : public spm_tclSwitchOnStatisticsTemplate< dp_tclSpmDpEngDataSwitchOnHistory, dp_tclSpmDpEngDataDeviceOnCount >
{
public:
spm_tclSwitchOnStatistics( const ISpmFactory& factory );

protected:
virtual const tChar*getName( ) const { return( "spm_tclSwitchOnStatistics" ); }
};

class spm_tclSWVersionSwitchOnStatistics : public spm_tclSwitchOnStatisticsTemplate< dp_tclSpmDpEngDataCurrentSWSwitchOnHistory, dp_tclSpmDpEngDataCurrentSWDeviceOnCount >
{
public:
spm_tclSWVersionSwitchOnStatistics( const ISpmFactory& factory );

protected:
virtual const tChar*getName( ) const { return( "spm_tclSWVersionSwitchOnStatistics" ); }
};

