/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_SubStatesStatistics.h
  * @brief        This is header file contains functions related to SubStates statistics data.
  * @copyright    (C) 2012 - 2018 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"

#include "spm_IStatistics.h"
#include "spm_SubStateDefines.h"

// possible accesses to the statistics data
#define SPM_U32_STATISTIC_TIPPER                  0x0000
#define SPM_U32_STATISTIC_SCONT                   0x0001
#define SPM_U32_STATISTIC_IGNITION                0x0002
#define SPM_U32_STATISTIC_DOOROPEN                0x0003
#define SPM_U32_STATISTIC_DIAG                    0x0004
#define SPM_U32_STATISTIC_DOWNLOAD                0x0005
#define SPM_U32_STATISTIC_PHONE                   0x0006
#define SPM_U32_STATISTIC_CVM_LOW                 0x0007
#define SPM_U32_STATISTIC_CVM_CR_LOW              0x0008
#define SPM_U32_STATISTIC_CVM_HIGH                0x0009
#define SPM_U32_STATISTIC_CVM_CR_HIGH             0x000a
#define SPM_U32_STATISTIC_ON_REACHED              0x000b
#define SPM_U32_STATISTIC_ON_REACHED_STORE        0x000c
#define SPM_U32_STATISTIC_LOW_VOLT_SHUTDOWN       0x000d
#define SPM_U32_STATISTIC_LOW_VOLT_SHUTDOWN_RESET 0x000e
/*!
  *  \class spm_tclSubStateStatisticsTemplate
  *  \brief This class is used for subState statistics of system. The template type
  *         T1: StatisticEng data pool of TSpmSubStatesStatisticsData type inside (OnOff trigger: OnTipperCount; SContCount; IgnitionCount; DoorOpenCount; DiagCount; DownloadCount; PhoneCount; voltage count,... ).
  */
template < typename T >
class spm_tclSubStateStatisticsTemplate : public ISpmStatistics
{
public:
spm_tclSubStateStatisticsTemplate( const ISpmFactory& factory, enStatisticsType eStatType );
virtual ~spm_tclSubStateStatisticsTemplate( );

virtual tVoid vSetNewData( tU32 u32StatisticType ) const;

virtual tVoid vGetData( void *pStatisticsData,
                        tU32  u32ObjectSize = 0 ) const;

virtual tVoid vErase( ) const;

virtual tVoid vTrace( ) const;

// implementation of functions needed for other statitics
virtual tBool bChkUnknownReset( tU32 /*u32StatisticType*/ ) const { return( FALSE ); } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual tVoid vGetLastReset( TSpmResetElem */*pLastResetData*/ ) const { }             //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual std::string szAsString( ) const { return( "" ); }
virtual tVoid vUpdateResetCounter( tVoid ) const {}

// trace handling
virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){ } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

protected:
// ISpmBase interface functions
virtual tVoid vGetReferences( ){ }
virtual tVoid vStartCommunication( ){ }
virtual const tChar*getName( ) const { return( "spm_tclSubStateStatisticsTemplate" ); }
};

/*!
  *  \class spm_tclSubStateStatistics
  *  \brief This class works for subState statistics of system.

        This class provide interfaces to get and update subStateStatistics data in the datapool dp_tclSpmDpEngDataStatisticEng .

        This class is used by spm_tclCriticalVoltageManagerCustom, spm_tclCriticalVoltageManagerIntern,
        spm_CriticalVoltageManagerIntern, spm_tclSubStateHandler to set new statistics data .

        The spm_tclFactory object creates an instance of this class.
  */
class spm_tclSubStateStatistics : public spm_tclSubStateStatisticsTemplate < dp_tclSpmDpEngDataStatisticEng >
{
public:
spm_tclSubStateStatistics( const ISpmFactory& factory );

protected:
virtual const tChar*getName( ) const { return( "spm_tclSubStateStatistics" ); }
};

/*!
  *  \class spm_tclSWVersionSubStateStatistics
  *  \brief This class works for subState statistics of system.
  */
class spm_tclSWVersionSubStateStatistics : public spm_tclSubStateStatisticsTemplate < dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng >
{
public:
spm_tclSWVersionSubStateStatistics( const ISpmFactory& factory );

protected:
virtual const tChar*getName( ) const { return( "spm_tclSWVersionSubStateStatistics" ); }
};