/*!
  * \file spm_SubStatesStatistics.cpp
  *  \brief
  *    SubStates statistics of the system.
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2011-2018 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  * Date      | Author               | Modification
  * 09.11.12  | CM-AI/PJ-G33 Rossner | initial version
  ******
  */

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// -----------------------------------------------------------------------------
// includes FC SPM
// -----------------------------------------------------------------------------
#include "spm_Config.h"
#include "spm_SubStatesStatistics.h"
#include "spm_IFactory.h"
#include "timeConvert.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
 #include "trcGenProj/Header/spm_SubStatesStatistics.cpp.trc.h"
#endif
// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

/******************************************************************************
  | local #define (scope: module-local)
  |-----------------------------------------------------------------------*/
template < typename T >
spm_tclSubStateStatisticsTemplate<T>::spm_tclSubStateStatisticsTemplate( const ISpmFactory& factory, enStatisticsType eStatType )
   : ISpmStatistics( factory ){
   _eStatType = eStatType;
}
template < typename T >
spm_tclSubStateStatisticsTemplate<T>::~spm_tclSubStateStatisticsTemplate( ){
}

template < typename T >
tVoid spm_tclSubStateStatisticsTemplate<T>::vSetNewData( tU32 u32StatisticType ) const {
/*!
  * \fn
  *  \brief
  *    update substate information to data pool.
  *
  *  \note
  *  \version
  *  \callgraph
  *  \callergraph
  ******
  */
   TSpmSubStatesStatisticsData    s;

   T oStat;

   s = oStat.tGetData( );

   switch ( u32StatisticType ){
      case SPM_U32_STATISTIC_TIPPER:
         s._u32OnTipperCount++;
         break;

      case SPM_U32_STATISTIC_SCONT:
         s._u32SContCount++;
         break;

      case SPM_U32_STATISTIC_IGNITION:
         s._u32IgnitionCount++;
         break;

      case SPM_U32_STATISTIC_DOOROPEN:
         s._u32DoorOpenCount++;
         break;

      case SPM_U32_STATISTIC_DIAG:
         s._u32DiagCount++;
         break;

      case SPM_U32_STATISTIC_DOWNLOAD:
         s._u32DownloadCount++;
         break;

      case SPM_U32_STATISTIC_PHONE:
         s._u32PhoneCount++;
         break;

      case SPM_U32_STATISTIC_CVM_LOW:
         s._u32LowVoltageCount++;
         break;

      case SPM_U32_STATISTIC_CVM_CR_LOW:
         s._u32CrLowVoltageCount++;
         break;

      case SPM_U32_STATISTIC_CVM_HIGH:
         s._u32HighVoltageCount++;
         break;

      case SPM_U32_STATISTIC_CVM_CR_HIGH:
         s._u32CrHighVoltageCount++;
         break;

      case SPM_U32_STATISTIC_ON_REACHED:
         s._u32OnReachedCount++;
         break;

      case SPM_U32_STATISTIC_ON_REACHED_STORE:
         if ( s._u32OnReachedSecurityCount < 100 ){
            s._u32OnReachedSecurityCount++;
         }
         break;

      case SPM_U32_STATISTIC_LOW_VOLT_SHUTDOWN:
         s._u32LowVoltageShutdownCount++;
         s._u32LowVoltageCurrentShutdownCount++;
         break;

      case SPM_U32_STATISTIC_LOW_VOLT_SHUTDOWN_RESET:
         s._u32LowVoltageCurrentShutdownCount = 0;
         break;

      default:
         break;
   } // switch

   oStat.vSetData( s );

   switch ( _eStatType )
   {
      case SPM_U32_STATISTIC_GLOBAL:
      {
         SPM_GET_CLASS_REFERENCE_NEW_VAR( poclSWVersionSubStateStatistics, spm_tclSWVersionSubStateStatistics, ISpmStatistics );
         poclSWVersionSubStateStatistics->vSetNewData( u32StatisticType );
         break;
      }
      default:
         break;
   }
} // vSetNewData
template < typename T >
tVoid spm_tclSubStateStatisticsTemplate<T>::vGetData( void *pStatistics,
                                           tU32  u32ObjectSize ) const {
/*!
  * \fn
  *  \brief
  *    get substate information from data pool.
  *
  *  \note
  *  \version
  *  \callgraph
  *  \callergraph
  ******
  */
   if ( pStatistics != NULL ){
      T oStat;
      TSpmSubStatesStatisticsData    tTmp = oStat.tGetData( );
      if ( u32ObjectSize >= sizeof( TSpmSubStatesStatisticsData ) ){
         memcpy( pStatistics, &tTmp, sizeof( TSpmSubStatesStatisticsData ) );
      }
   }
}
template < typename T >
tVoid spm_tclSubStateStatisticsTemplate<T>::vErase( ) const {
/*!
  * \fn
  *  \brief
  *    clean up substate information of data pool.
  *
  *  \note
  *  \version
  *  \callgraph
  *  \callergraph
  ******
  */
   TSpmSubStatesStatisticsData    s;

   memset( &s, 0, sizeof( s ) );

   T oStat;
   oStat.vSetData( s );
}
template < typename T >
tVoid spm_tclSubStateStatisticsTemplate<T>::vTrace( ) const {
/*!
  * \fn
  *  \brief
  *    Trace substate information of data pool.
  *
  *  \note
  *  \version
  *  \callgraph
  *  \callergraph
  ******
  */
   TSpmSubStatesStatisticsData    s;

   T oStat;

   s = oStat.tGetData( );

   ETG_TRACE_FATAL( ( "OnTipper Count:                  %d", s._u32OnTipperCount ) );
   ETG_TRACE_FATAL( ( "SCont Count:                     %d", s._u32SContCount ) );
   ETG_TRACE_FATAL( ( "Ignition Count:                  %d", s._u32IgnitionCount ) );
   ETG_TRACE_FATAL( ( "DoorOpen Count:                  %d", s._u32DoorOpenCount ) );
   ETG_TRACE_FATAL( ( "Diag Count:                      %d", s._u32DiagCount ) );
   ETG_TRACE_FATAL( ( "Download Count:                  %d", s._u32DownloadCount ) );
   ETG_TRACE_FATAL( ( "Phone Count:                     %d", s._u32PhoneCount ) );
   ETG_TRACE_FATAL( ( "Low voltage Count:               %d", s._u32LowVoltageCount ) );
   ETG_TRACE_FATAL( ( "Critical Low voltage Count:      %d", s._u32CrLowVoltageCount ) );
   ETG_TRACE_FATAL( ( "High voltage Count:              %d", s._u32HighVoltageCount ) );
   ETG_TRACE_FATAL( ( "Critical High voltage Count:     %d", s._u32CrHighVoltageCount ) );
   ETG_TRACE_FATAL( ( "Low voltage shutdown Count:      %d", s._u32LowVoltageShutdownCount ) );
   ETG_TRACE_FATAL( ( "Cur Low voltage shutdown Count:  %d", s._u32LowVoltageCurrentShutdownCount ) );
   ETG_TRACE_FATAL( ( "SystemState OnReached Count:     %d", s._u32OnReachedCount ) );
} // vTrace

spm_tclSubStateStatistics::spm_tclSubStateStatistics( const ISpmFactory& factory )
   : spm_tclSubStateStatisticsTemplate< dp_tclSpmDpEngDataStatisticEng >( factory, SPM_U32_STATISTIC_GLOBAL )
{
}

spm_tclSWVersionSubStateStatistics::spm_tclSWVersionSubStateStatistics( const ISpmFactory& factory )
   : spm_tclSubStateStatisticsTemplate< dp_tclSpmDpEngDataCurrentSWVersionSubStatesStatisticEng >( factory, SPM_U32_STATISTIC_SOFTWARE_VERSION )
{
}

// EOF

