/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          spm_SoftwareVersionStatistics.h
  * @PROJECT:      CMD project
  * @brief         include header file
  *
  * ----------------------------------------------------------------------------
  * @copyright     (C) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_IPowerOnStatistics.h"
#include "spm_ISoftwareVersionStatistics.h"
#include "spm_IStatistics.h"
#include "spm_IResetStatistics.h"
#include "spm_ISystemLoadStatistics.h"
#include "spm_ISystemStateStatistics.h"
#include "spm_ISoftwareVersionStatistics.h"

class spm_tclSoftwareVersionStatistics : public ISpmSoftwareVersionStatistics
{
public:
spm_tclSoftwareVersionStatistics( const ISpmFactory& factory );
virtual ~spm_tclSoftwareVersionStatistics( );

virtual tVoid vSetNewData( tU32 /*u32StatisticType*/ ) const { }

virtual tVoid vGetData( void *pStatistics,
                        tU32  u32ObjectType ) const;

virtual tBool vGetDataWithIndex( TSpmSoftwareVersionStatisticsData *pStatisticsData,
                                 tU32  u32Index = 0 );

virtual tVoid vErase( ) const;

virtual tVoid vTrace( ) const;

// implementation of functions needed for other statitics
virtual tBool bChkUnknownReset( tU32 /*u32StatisticType*/ ) const { return( FALSE ); }
virtual tVoid vGetLastReset( TSpmResetElem*/*pLastResetData*/ ) const { }
virtual std::string szAsString( ) const { return( "" ); }
virtual tVoid vUpdateResetCounter( tVoid ) const {}

// trace handling
virtual tVoid vHandleTraceMessage( const tUChar* puchData );

protected:
// ISpmBase interface functions
virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( ){ }
virtual tVoid vStartLateCommunication( );

virtual const tChar*getName( ) const { return( "spm_tclSoftwareVersionStatistics" ); }

private:
TSpmSoftwareVersionStatisticsData _tSoftwareVersionStatisticsData;

ISpmPowerOnStatistics      *_poclSWVersionPowerOnCount;
ISpmResetStatistics        *_poclSWVersionResetStatistics;
ISpmStatistics             *_poclSWVersionSubStateStatistics;
ISpmSystemLoadStatistics   *_poclSWVersionCpuUsageStatistics;
ISpmSystemLoadStatistics   *_poclSWVersionRamUsageStatistics;
ISpmSystemLoadStatistics   *_poclSWVersionStartupTimeStatistics;
ISpmSystemStateStatistics  *_poclSWVersionSystemStateStatistics;
ISpmStatistics             *_poclSWVersionWakeupStatistics;
ISpmStatistics             *_poclSWVersionSwitchOnStatistics;

virtual tVoid vGetSoftwareVersionReg( TSpmSoftwareVersion *pSWVersion );
virtual tVoid vGetSoftwareVersionDP( TSpmSoftwareVersion *pSWVersion );
virtual tVoid vGetSystemLoadUsageData( TSpmSystemLoadStatisticsData *pSystemLoadData, ISpmSystemLoadStatistics *pSystemLoadStatistic );
virtual tVoid vGetResetStatisticsData( TSpmResetStatisticsData *pResetStatisticsData, ISpmResetStatistics *pResetStatistics );
virtual tVoid vGetSubStateStatisticsData( TSpmSubStatesStatisticsData *pSubStatesStatisticsData, ISpmStatistics *pSubStateStatistics );
virtual tU32  vGetPowerOnCount( ISpmPowerOnStatistics *pPowerOnCount );
virtual tVoid vGetResetHistory( TSpmResetElem *pResetHistoryStatisticsData, ISpmResetStatistics *pResetStatistics );
virtual tVoid vGetWakeupHistory( TSpmWakeupStatisticsData *pWakeupStatisticsData, ISpmStatistics *pWakeupStatistics );
virtual tVoid vGetSwitchOnHistory( TSpmSwitchOnStatisticsData *pSwitchOnStatisticsData, ISpmStatistics *pSwitchOnStatistics );
virtual tVoid vGetSystemStateHistory( TSpmSystemStateStatisticsData *pSystemStateStatisticsData, ISpmSystemStateStatistics *pSystemStateStatistics );
virtual tVoid vGetErrSystemDataStateHistoryStack01( TSpmSystemStateStatisticsData *pSystemStateStatisticsDataErr01, ISpmSystemStateStatistics *pSystemStateStatistics );
virtual tVoid vGetErrSystemDataStateHistoryStack02( TSpmSystemStateStatisticsData *pSystemStateStatisticsDataErr02, ISpmSystemStateStatistics *pSystemStateStatistics );
virtual tVoid vGetErrSystemDataStateHistoryStack03( TSpmSystemStateStatisticsData *pSystemStateStatisticsDataErr03, ISpmSystemStateStatistics *pSystemStateStatistics );
virtual tVoid vGetErrSystemDataStateHistoryStack04( TSpmSystemStateStatisticsData *pSystemStateStatisticsDataErr04, ISpmSystemStateStatistics *pSystemStateStatistics );
virtual tVoid vGetErrSystemDataStateHistoryStack05( TSpmSystemStateStatisticsData *pSystemStateStatisticsDataErr05, ISpmSystemStateStatistics *pSystemStateStatistics );
virtual tVoid vOnSWVersionUpdate( );
virtual tVoid vGetElemDataFromDataPool( );
};

