/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ResetStatistics.h
  * @brief        This is header file contains functions to get or set Reset statistics data.
  * @copyright    (C) 2012 - 2018 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_IResetStatistics.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"

/*!
  *  \class spm_tclResetStatisticsTemplate
  *  \brief This class is used to handle reset statistics of the system. The template type
  *         T1: ResetStatistic data pool of TSpmResetStatisticsData type inside (contains APP, SCC, ADR reset type).
  *         T2: ResetHistory data pool contains a list of TSpmResetElem (time and type of reset)
  *         T3: StateHistory data pool contains a list of TSpmSystemStateStatisticsData (time and reset reason)
  */
template < typename T1, typename T2, typename T3 >
class spm_tclResetStatisticsTemplate : public ISpmResetStatistics
{
public:
spm_tclResetStatisticsTemplate( const ISpmFactory& factory, tBool bUpdateProperty, enStatisticsType eStatType );
virtual ~spm_tclResetStatisticsTemplate( );

virtual tVoid vSetNewData( tU32 u32StatisticType ) const;

virtual tVoid vGetData( void *pStatisticsData,
                        tU32  u32ObjectSize = 0 ) const;

virtual tVoid vGetData( TSpmResetElem *pStatistics,
                        tU32  u32ObjectSize = 0 ) const;

virtual tVoid vErase( ) const;

virtual tVoid vTrace( ) const;

virtual tBool bChkUnknownReset( tU32 u32StatisticType ) const;

virtual tVoid vGetLastReset( TSpmResetElem *pLastResetData ) const;

virtual std::string szAsString( ) const { return( "" ); }
virtual tVoid vUpdateResetCounter( tVoid ) const;

// trace handling
virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){ }  //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

protected:
virtual const tChar*getName( ) const { return( "spm_tclResetStatisticsTemplate" ); }
// ISpmBase interface functions
virtual tVoid vGetReferences( ){ }
virtual tVoid vStartCommunication( );

virtual tVoid vStartLateCommunication( );
tBool   _bUpdateProperty;

private:
virtual tVoid vUpdateOnInterface( ) const;

};

/*!
  *  \class spm_tclResetStatistics
  *  \brief This class is used to handle reset statistics of the system. It uses dp_tclSpmDpEngDataResetStatistic to set and get ResetStatistic data .
        It does update in dp_tclSpmDpEngDataResetStatistic after setting data .
        It checks for unknown reset according to u32StatisticType . It also updates reset counter in dp_tclSpmDpEngDataResetStatistic.

        This is used by spm_tclLocalApplicationManagerConfig, spm_tclSubStateHandler and spm_tclSystemPowerManager to set new data . And
        spm_tclSystemStateManagerConfig to update reset.

        The spm_tclFactory object creates an instance of this class.
  */

class spm_tclResetStatistics : public spm_tclResetStatisticsTemplate< dp_tclSpmDpEngDataResetStatistic, dp_tclSpmDpEngDataResetHistory, dp_tclSpmDpEngStateHistory >
{
public:
spm_tclResetStatistics( const ISpmFactory& factory );

protected:
virtual const tChar*getName( ) const { return( "spm_tclResetStatistics" ); }
};

/*!
  *  \class spm_tclSWVersionResetStatistics
  *  \brief This class is used to handle reset statistics of the system. It uses dp_tclSpmDpEngDataResetStatistic to set and get ResetStatistic data .
  */

class spm_tclSWVersionResetStatistics : public spm_tclResetStatisticsTemplate< dp_tclSpmDpEngDataCurrentSWVersionResetStatistic, dp_tclSpmDpEngDataCurrentSWVersionResetHistory, dp_tclSpmDpEngStateCurrentSWVersionHistory >
{
public:
spm_tclSWVersionResetStatistics( const ISpmFactory& factory );

protected:
virtual const tChar*getName( ) const { return( "spm_tclSWVersionResetStatistics" ); }
};