/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          spm_PowerSupplyStatistics.h
  * @PROJECT:      CMD project
  * @brief         include header file
  *
  * ----------------------------------------------------------------------------
  * @copyright     (C) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_IPowerSupplyStatistics.h"

class spm_tclPowerSupplyStatistics : public ISpmPowerSupplyStatistics
{
public:
spm_tclPowerSupplyStatistics( const ISpmFactory& factory );
virtual ~spm_tclPowerSupplyStatistics( );

virtual tVoid vSetNewData( tU32 u32StatisticType ) const;

virtual tVoid vGetData( void *pStatisticsData,
                        tU32  u32ObjectSize = 0 ) const { (void)( pStatisticsData ); (void)( u32ObjectSize ); }

virtual tVoid vGetData( TSpmVoltageHistogramRangeStatisticsData *pStatistics,
                        tU32  u32ObjectSize ) const;

virtual tVoid vErase( ) const { }

virtual tVoid vTrace( ) const;

// implementation of functions needed for other statitics
virtual tBool bChkUnknownReset( tU32 /*u32StatisticType*/ ) const { return( FALSE ); } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual tVoid vGetLastReset( TSpmResetElem*/*pLastResetData*/ ) const { }            //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual std::string szAsString( ) const { return( "" ); }
virtual tVoid vUpdateResetCounter( tVoid ) const {}

// trace handling
virtual tVoid vHandleTraceMessage( const tUChar *puchData );

virtual tVoid vUpdateVoltageHistogram( tU16 tVoltageValue );

virtual tVoid vEraseVoltageHistogram( );

protected:
// ISpmBase interface functions
virtual tVoid vGetReferences( ){ }
virtual tVoid vStartCommunication( );
virtual const tChar*getName( ) const { return( "spm_tclPowerSupplyStatistics" ); }

private:
std::vector < TSpmVoltageHistogramRangeStatisticsData > _vecVoltageHistogram;
tU32                                _u32LastUpdateVoltageCall;
};

