/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ISystemStateStatistics.h
  * @brief        This is header file contains interfaces to get or set SystemState statistics data.
  * @copyright    (C) 2015 - 2016 Robert Bosch Engineering and Business Solutions Limited.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include <string>
#include "spm_IStatistics.h"

/*!
  *  \class ISpmSystemStateStatistics
  *  \brief This abstract class provides interfaces to get or set statistics data specifically for
  *         System State.
  */
class ISpmSystemStateStatistics : public ISpmStatistics
{
public:
// constructor
ISpmSystemStateStatistics( const ISpmFactory& factory ) : ISpmStatistics( factory ){ }
virtual ~ISpmSystemStateStatistics( ){ }

virtual const tChar*getInterfaceName( ) const { return( "ISpmSystemStateStatistics" ); }

virtual tVoid vUpdateSystemStateHistory( TSpmSystemStateStatisticsData& oStateElem ) const                     = 0;

virtual tVoid vGetDataSysStateHistory( TSpmSystemStateStatisticsData *pStatistics, tU32  u32ObjectSize ) const = 0;

virtual tVoid vGetDataErrSysStateStateHistoryStack01( TSpmSystemStateStatisticsData *pStatistics, tU32  u32ObjectSize ) const = 0;

virtual tVoid vGetDataErrSysStateStateHistoryStack02( TSpmSystemStateStatisticsData *pStatistics, tU32  u32ObjectSize ) const = 0;

virtual tVoid vGetDataErrSysStateStateHistoryStack03( TSpmSystemStateStatisticsData *pStatistics, tU32  u32ObjectSize ) const = 0;

virtual tVoid vGetDataErrSysStateStateHistoryStack04( TSpmSystemStateStatisticsData *pStatistics, tU32  u32ObjectSize ) const = 0;

virtual tVoid vGetDataErrSysStateStateHistoryStack05( TSpmSystemStateStatisticsData *pStatistics, tU32  u32ObjectSize ) const = 0;

virtual tU32 u32AddErrorHistory( ) const                = 0;

virtual tVoid vEraseErrorHistory( ) const              = 0;

virtual tVoid vTraceErrorHistory( tU8 u8Number ) const = 0;

};

