/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_IStatistics.h
  * @brief        This is header file contains interfaces to get or set statistics data.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include <string>
#include "spm_ISpmBase.h"
#include "spm_StatisticTypes.h"

// -----------------------------------------------------------------------------
// class definition
// -----------------------------------------------------------------------------

/*!
  *  \class ISpmStatistics
  *  \brief This abstract class provides interfaces to get or set statistics data .
          This class also delivers interfaces to check unknown resets, get last reset and update reset counter.
  */
class ISpmStatistics : public ISpmBase
{
public:
// constructor
ISpmStatistics( const ISpmFactory& factory ) : ISpmBase( factory ){_eStatType = SPM_U32_STATISTIC_GLOBAL; }
virtual ~ISpmStatistics( ){ }

virtual tVoid vErase( ) const                                      = 0;

virtual tVoid vTrace( ) const                                      = 0;

virtual tVoid vSetNewData( tU32 u32StatisticType ) const           = 0;

virtual tVoid vGetData( void *pStatisticsData,
                        tU32  u32ObjectSize = 0 ) const            = 0;

virtual const tChar*getName( ) const                               = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmStatistics" ); }

// functions currently only used by ResetStatistic
virtual tBool bChkUnknownReset( tU32 u32StatisticType ) const      = 0;

virtual tVoid vGetLastReset( TSpmResetElem *pLastResetData ) const = 0;

virtual std::string szAsString( ) const                            = 0;

virtual tVoid vUpdateResetCounter( tVoid ) const = 0;

protected:
enStatisticsType     _eStatType;
};

