/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_IPowerOnStatistics.h
  * @brief        This is header file contains interfaces to get or set PowerOnCount statistics data.
  * @copyright    (C) 2014 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include <string>
#include "spm_IStatistics.h"

/*!
  *  \class ISpmPowerOnStatistics
  *  \brief This abstract class provides interfaces to get or set statistics data specifically for
  *         PowerOnCount.
  */
class ISpmPowerOnStatistics : public ISpmStatistics
{
public:
// constructor
ISpmPowerOnStatistics( const ISpmFactory& factory ) : ISpmStatistics( factory ){ }
virtual ~ISpmPowerOnStatistics( ){ }

virtual const tChar*getInterfaceName( ) const { return( "ISpmPowerOnStatistics" ); }

virtual tVoid vCheckPwrOnTime( )                 = 0;

virtual tVoid vSetPwrOnTime( tU32 u32PwrOnTime ) = 0;

virtual tVoid vSetPwrOnLastSystemRunTime( tU32 u32LastSystemRunTime ) = 0;

virtual tU32 u32GetCurrentPwrOnTime( ) const     = 0;

};

