/************************************************************************
  * FILE:         spm_SyncHandler.h
  * PROJECT:      NextGen
  * SW-COMPONENT: fc_spm
  * ----------------------------------------------------------------------
  *
  * DESCRIPTION:  Synchronize tasks --> Context switch to SPM main (asf) thread .
  *
  * ----------------------------------------------------------------------
  * COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
  * HISTORY:
  * Date      | Author               | Modification
  * 21.01.14  | CM-AI/EPB2 Kollai    | initial version
  *
  *************************************************************************/

#pragma once

#include "spm_ISyncHandler.h"

class ISpmFactory;
class ISpmSubStateClient;
class ISpmStartupSystem;
class ISpmCcaServiceServer;
class ISpmWorkerServer;
#ifdef VARIANT_S_FTR_ENABLE_PROCESS_CFG
   class spm_ProcessShutdown;
#endif
class spm_tclSyncHandler : public ISpmSyncHandler
{
private:
ISpmSubStateClient     *_poclSubStateHandler;
ISpmStartupSystem      *_poclStartup;
ISpmCcaServiceServer   *_poclCcaServiceHandler;
ISpmWorkerServer       *_poclWorkerServer;
#ifdef VARIANT_S_FTR_ENABLE_PROCESS_CFG
   spm_ProcessShutdown *_poclProcessShutdown;
#endif

public:
spm_tclSyncHandler( const ISpmFactory& factory );
virtual ~spm_tclSyncHandler( );

virtual tVoid vDispatchTask( tU16 u16Command );

virtual tVoid vSwitchContext( tU16 u16Command );

protected:
// ISpmBase interface functions
virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

virtual const tChar*getName( ) const { return( "spm_tclSyncHandler" ); }
virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );

};

