/*!
  * \file spm_SyncHandler.cpp
  *  \brief
  *    Checks wakeup reason at startup .
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  * Date      | Author             | Modification
  * 21.01.14  | CM-AI/EPB2 Kollai    | initial version
  ******
  */

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_spm_if.h"

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------
#include "spm_Config.h"

#include "spm_SyncHandler.h"

#include "spm_ISubStateClient.h"
#include "spm_IStartupSystem.h"
#include "spm_ICcaServiceServer.h"
#include "spm_IWorkerClient.h"
#ifdef VARIANT_S_FTR_ENABLE_PROCESS_CFG
   #include "spm_ProcessShutdown.h"
#endif

#include "spm_IFactory.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
#include "trcGenProj/Header/spm_SyncHandler.cpp.trc.h"
#endif
// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

// -----------------------------------------------------------------------------
// defines
// -----------------------------------------------------------------------------

spm_tclSyncHandler::spm_tclSyncHandler( const ISpmFactory& factory )
   : ISpmSyncHandler( factory )
   , _poclSubStateHandler( NULL )
   , _poclStartup( NULL )
   , _poclCcaServiceHandler( NULL )
   , _poclWorkerServer( NULL )
#ifdef VARIANT_S_FTR_ENABLE_PROCESS_CFG
      , _poclProcessShutdown( NULL )
#endif
{
}

spm_tclSyncHandler::~spm_tclSyncHandler( ){
   _poclSubStateHandler    = NULL;
   _poclStartup            = NULL;
   _poclCcaServiceHandler  = NULL;
   _poclWorkerServer       = NULL;
   #ifdef VARIANT_S_FTR_ENABLE_PROCESS_CFG
      _poclProcessShutdown = NULL;
   #endif
}

tVoid spm_tclSyncHandler::vGetReferences( ){
   // get all needed references now -> all SPM objects are now available

   SPM_GET_IF_REFERENCE_USE_VAR( _poclStartup,           ISpmStartupSystem );
   SPM_GET_IF_REFERENCE_USE_VAR( _poclCcaServiceHandler, ISpmCcaServiceServer );
   SPM_GET_IF_REFERENCE_USE_VAR( _poclWorkerServer,      ISpmWorkerServer );
   SPM_GET_IF_REFERENCE_USE_VAR( _poclSubStateHandler,   ISpmSubStateClient );

   #ifdef VARIANT_S_FTR_ENABLE_PROCESS_CFG
      _poclProcessShutdown = dynamic_cast < spm_ProcessShutdown* >( _crfFactory.getSpmObjHandler( "spm_ProcessShutdown" ) );
      SPM_NULL_POINTER_CHECK( _poclProcessShutdown );
   #endif
} // vGetReferences

tVoid spm_tclSyncHandler::vStartCommunication( ){
} // vStartCommunication

tVoid spm_tclSyncHandler::vDispatchTask( tU16 u16Command ){
   tU32 u32StartTime = OSAL_ClockGetElapsedTime( );

   ETG_TRACE_USR4( ( "spm_tclSyncHandler::vDispatchTask(), internal message received --> CmdId: %u.", ETG_ENUM( SPM_SYNC_TRIGGER, u16Command ) ) );

   switch ( u16Command ){
      case SPM_CTX_SWITCH_SUBSTATE_TRIGGER:
      {
            SPM_NULL_POINTER_CHECK( _poclSubStateHandler );
         _poclSubStateHandler->vHandleMsgQueue( );
      }
      break;

      case SPM_CTX_SWITCH_PROC_CHECK_TRIGGER:
      {
            SPM_NULL_POINTER_CHECK( _poclStartup );
         _poclStartup->vCheckForProcessToStart( );
         #ifdef VARIANT_S_FTR_ENABLE_PROCESS_CFG
            SPM_NULL_POINTER_CHECK( _poclProcessShutdown );
            _poclProcessShutdown->vCheckWaitForSync( );
         #endif
      }
      break;

      case SPM_CTX_SWITCH_WORKER_TRIGGER:
      {
            SPM_NULL_POINTER_CHECK( _poclWorkerServer );
         _poclWorkerServer->vHandleMsgQueue( );
      }
      break;

      case SPM_CTX_SWITCH_PROC_SHUTDOWN_TRIGGER:
      {
         #ifdef VARIANT_S_FTR_ENABLE_PROCESS_CFG
            SPM_NULL_POINTER_CHECK( _poclProcessShutdown );
            _poclProcessShutdown->vHandleMsgQueue( );
         #endif
      }
      break;

      default:
      {
         ETG_TRACE_FATAL( ( "spm_tclSyncHandler::vDispatchTask(): Unknown parameter %d", u16Command ) );
      }
   } // switch
   ETG_TRACE_USR4( ( "spm_tclSyncHandler::vDispatchTask(), Duration of command: %u --> %dms.", ETG_ENUM( SPM_SYNC_TRIGGER, u16Command ), OSAL_ClockGetElapsedTime( ) - u32StartTime ) );

} // vDispatchTask

tVoid spm_tclSyncHandler::vSwitchContext( tU16 u16Command ){
   SPM_NULL_POINTER_CHECK( _poclCcaServiceHandler );
   ETG_TRACE_USR4( ( "spm_tclSyncHandler::vSwitchContext(), send message --> CmdId: %u.", ETG_ENUM( SPM_SYNC_TRIGGER, u16Command ) ) );

   _poclCcaServiceHandler->vPostInternalMessage( u16Command );
} // vSwitchContext

