/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ProcessDatabase.h
  * @brief        This is header file contains functions for ProcessDatabase.
  * @copyright    (C) 2013 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include <map>
#include <list>
#include <string>
#include <vector>

#include "spm_IProcessDatabase.h"

/*!
  *  \class spm_tclProcessDatabase
  *  \brief This class is the access point to all process supervision relevant information.
          It maintains two maps of processes for supervision - one for SPM started processes and another
          for additional set of processes.

          Invoke vAccessDatabase method before accessing the process supervision relevant information and
          invoke vReleaseDatabase method after accessing the same.

          spm_tclFactory creates an instance of this class and spm_tclProcessSupervision uses this class to access the maps of processes
          used for supervision.

          spm_tclProcessSupervision accesses process supervision relevant information from this class.

  */
class spm_tclProcessDatabase : public ISpmProcessDatabase
{
public:
spm_tclProcessDatabase( const ISpmFactory& factory );
virtual ~spm_tclProcessDatabase( );

virtual tBool bUpdateMapStartedProc( const TProcessConfiguration& processConfig );

virtual tBool bUpdateMapAdditionalProc( const TProcessConfiguration& processConfig );

virtual tBool bUpdateExternalProcess( const TProcessSupervisionConfiguration& processConfig );

virtual tBool bRemoveMapProc( const std::string strProcessName );

virtual TMapStartedProcesses                   & mapGetStartedProcesses( ){ return( _oStartedProcesses ); }
virtual TMapStartedProcesses                   & mapGetAdditionalProcesses( ){ return( _oAdditionalProcesses ); }
virtual std::vector < TProcessSupervisionConfiguration >& vecGetExternalProcesses( ){ return( _vecExternalProcessesList ); }

OSAL_tSemHandle                                  _hProcessConfigSem;

virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

TMapStartedProcesses                             _oStartedProcesses;
TMapStartedProcesses                             _oAdditionalProcesses;
std::vector < TProcessSupervisionConfiguration > _vecExternalProcessesList;

private:
OSAL_tThreadID                                   _idt;
OSAL_tProcessID                                  _idp;
std::string                                      _szThreadName;

protected:
virtual tVoid                                    vAccessDatabaseIntern( tVoid );
virtual tVoid                                    vReleaseDatabaseIntern( tVoid );

virtual const tChar*getName( ) const { return( "spm_tclProcessDatabase" ); }
virtual tVoid vGetReferences( ){ }
virtual tVoid vStartCommunication( ){ }
};

