/************************************************************************
  * FILE:         spm_ISyncHandler.h
  * PROJECT:      NextGen
  * SW-COMPONENT: fc_spm
  * ----------------------------------------------------------------------
  *
  * DESCRIPTION:  Interface to spm_tclSyncHandler.
  *
  * ----------------------------------------------------------------------
  * COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
  * HISTORY:
  * Date      | Author               | Modification
  * 10.06.15  | CM-AI/EPB2 Kollai    | initial version
  *
  *************************************************************************/

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_ISpmBase.h"

#define SPM_CTX_SWITCH_SUBSTATE_TRIGGER       0xfe00
#define SPM_CTX_SWITCH_PROC_CHECK_TRIGGER     0xfe01
#define SPM_CTX_SWITCH_WORKER_TRIGGER         0xfe02
#define SPM_CTX_SWITCH_PROC_SHUTDOWN_TRIGGER  0xfe03
#define SPM_CTX_SWITCH_MOST_TRIGGER           0xfe04


class ISpmSyncHandler : public ISpmBase
{
public:
ISpmSyncHandler( const ISpmFactory& factory ) : ISpmBase( factory ){}
virtual ~ISpmSyncHandler( ){}

virtual const tChar*getInterfaceName( ) const { return( "ISpmSyncHandler" ); }

virtual tVoid vDispatchTask( tU16 u16Command )  = 0;

virtual tVoid vSwitchContext( tU16 u16Command ) = 0;

};

