/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_CriticalVoltageManagerIntern.h
  * @brief        This is header file contains functions for voltage control management.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_CriticalVoltageManager.h"

class ISpmLocalAppManager;
class ISpmSubStateClient;
class ISpmOsalProxy;
class ISpmCcaServiceServer;
class ICcaDiaglogProxy;

/*!
  *  \class spm_tclCriticalVoltageManagerIntern
  *  \brief This class is based on voltage control management .
          This class handles all voltage related events low voltage start , high voltage start, critical high voltage start ,
        high voltage end, critical voltage timeout.

         It uses class spm_tclLocalApplicationManagerConfig to send critical voltage events and class spm_tclSubStateHandlerConfig to
        set substate.

        The spm_tclFactory object creates an instance of this class.

       class spm_tclSupervisionManagerConfig to get current voltage state.
  */
class spm_tclCriticalVoltageManagerIntern : public spm_tclCriticalVoltageManager
{
public:
spm_tclCriticalVoltageManagerIntern( const ISpmFactory& factory );
virtual ~spm_tclCriticalVoltageManagerIntern( );

// trace handling
virtual tVoid vHandleTraceMessage( const tUChar *puchData );

protected:
virtual tVoid vHandleOnLowVoltageStart( );

virtual tVoid vHandleOnLowVoltageEnd( );

virtual tVoid vHandleOnCriticalLowVoltageStart( );

virtual tVoid vHandleOnCriticalLowVoltageEnd( );

virtual tVoid vHandleOnHighVoltageStart( );

virtual tVoid vHandleOnHighVoltageEnd( );

virtual tVoid vHandleOnCriticalHighVoltageStart( );

virtual tVoid vHandleOnCriticalHighVoltageEnd( );

virtual tVoid vHandleOnLowVoltageEndTimeout( );

virtual tVoid vHandleOnCriticalLowVoltageEndTimeout( );

virtual tVoid vHandleOnLowVoltageTimeout( );

virtual tVoid vHandleOnHighVoltageTimeout( );

virtual tVoid vHandleOnCriticalVoltageTimeout( );

virtual tVoid vHandleOnLowVoltageAtStartup( );

virtual tVoid vUpdateCvmEvent( tU32 cvmEvent );

virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );

virtual const tChar*getName( ) const { return( "spm_tclCriticalVoltageManagerIntern" ); }


ISpmLocalAppManager  *_poclLocalAppManager;
ISpmSubStateClient   *_poclSubStateHandler;
ISpmCcaServiceServer *_poclCcaServiceHandler;
ISpmOsalProxy        *_poclOsalProxy;
ICcaDiaglogProxy     *_poDiagLog;

};

