/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_CriticalVoltageManager.h
  * @brief        This is header file contains interface functions for critical voltage management.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_ICvmClient.h"

class ISpmSystemPowerManager;

/*!
  *  \class spm_tclCriticalVoltageManager
  *  \brief This is the base class for critical voltage management.
  *
  *          When any critical voltage event happens, spm_tclOsalProxy notifies the  spm_tclCriticalVoltageManager about this event.
  *          The event can be LOW VOLTAGE START, LOW VOLTAGE END, CRITICAL LOW VOLTAGE START,CRITICAL LOW VOLTAGE END,
  *          HIGH VOLTAGE START, HIGH VOLTAGE END, CRITICAL HIGH VOLTAGE START,CRITICAL HIGH VOLTAGE END.
  *
  *          When any of these voltage events(either Low Voltage or High Voltage) is active for some duration, then
  *          this class posts this event information and then writes the voltage information to error memory
  *          through spm_tclSystemPowerManagerConfig.
  *
  */
class spm_tclCriticalVoltageManager : public ISpmCvmClient
{
public:
spm_tclCriticalVoltageManager( const ISpmFactory& factory );
virtual ~spm_tclCriticalVoltageManager( );

virtual tVoid vSetSystemState( tU32 u32CvmEvent ){ vHandleCvmEvent( u32CvmEvent ); }
virtual tU32 u32GetRemainingCriticalVoltageTime( );

virtual tU32 u32GetCurVoltageState( tVoid ){ return( _u32CcaCvmEvent ); }

protected:
virtual tVoid vHandleOnLowVoltageStart( ){}
virtual tVoid vHandleOnLowVoltageEnd( ){}
virtual tVoid vHandleOnCriticalLowVoltageStart( ){}
virtual tVoid vHandleOnCriticalLowVoltageEnd( ){}
virtual tVoid vHandleOnHighVoltageStart( ){}
virtual tVoid vHandleOnHighVoltageEnd( ){}
virtual tVoid vHandleOnCriticalHighVoltageStart( ){}
virtual tVoid vHandleOnCriticalHighVoltageEnd( ){}
virtual tVoid vHandleOnLowVoltageAtStartup( ){}
virtual tVoid vUpdateCvmEvent( tU32 /*cvmEvent*/ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

virtual tVoid vHandleOnLowVoltageEndTimeout( ){}
virtual tVoid vHandleOnCriticalLowVoltageEndTimeout( ){}
virtual tVoid vHandleOnLowVoltageTimeout( ){}
virtual tVoid vHandleOnHighVoltageTimeout( ){}
virtual tVoid vHandleOnCriticalVoltageTimeout( ){}

// Implementation of ISpmCvmClient interface
virtual tVoid vHandleCvmEvent( tU32 u32CvmEvent );

static tVoid vVoltageTimerCallback( tVoid *pArg );

static tVoid vCriticalVoltageTimerCallback( tVoid *pArg );

// Implementation of interface ISpmWorkerClient
virtual tVoid vHandleMessage( tU32 u32Message,
                              tU32 u32Parm = 0 );

virtual tBool bHandleSynchrounousCall( tU32   /*u32Message*/,
                                       tVoid */*args*/ ){ return( FALSE ); }  //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

virtual const tChar*getName( ) const { return( "spm_tclCriticalVoltageManager" ); }
virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );

tU32                    _u32VoltageState;
OSAL_tTimerHandle       _hCriticalVoltageTimer;
OSAL_tTimerHandle       _hVoltageTimer;

tU32                    _u32LowVoltageTimeout;
tU32                    _u32CritLowVoltageTimeout;

tU32                    _u32CcaCvmEvent;

ISpmSystemPowerManager *_poclSystemPowerManager;
ISpmWorkerServer       *_poclWorkerServer;

public:
// ISpmBase interface functions
virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
};

