/*!
  * \file  spm_SystemStateMachineServiceHandler_trace.cpp
  *  \brief
  *    Method definitions for testing via trace purposes.
  *               This list is generated.
  *
  *  \note
  *  PROJECT: NextGen
  *  SW-COMPONENT: FC SPM
  *  COPYRIGHT:    (C) 2013 - 2020 Robert Bosch GmbH, Hildesheim

  *  The reproduction, distribution and utilization of this file as
  *  well as the communication of its contents to others without express
  *  authorization is prohibited. Offenders will be held liable for the
  *  payment of damages. All rights reserved in the event of the grant
  *  of a patent, utility model or design.
  *
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "spm_Config.h"

// Trace specific includes can be put here
// spm_tclSystemStateMachineServiceHandler_include_ext: user specific code start
// spm_tclSystemStateMachineServiceHandler_include_ext: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
#include "trcGenProj/Header/spm_SystemStateMachineServiceHandler_trace.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

// Spm trace specific code can be put here
// spm_tclSystemStateMachineServiceHandler_include_spm: user specific code start
#include "spm_SystemStateMachineServiceHandler.h"
// spm_tclSystemStateMachineServiceHandler_include_spm: user specific code end


tVoid spm_tclSystemStateMachineServiceHandler::vHandleTraceMessage(const tUChar *puchData){
/*!
  * \fn
  *  \brief
  *    Interface function for the tracechannel.
  *
  *  \param[in]
  *    puchData - Trace command data.
  ******
  */
   tU32 u32MsgCode = ( puchData[1] << 8 ) | puchData[2];

   switch (u32MsgCode){

      case SPM_SSM_C_COMPONENT_STATUS:
      {
         // Trigger INC message 'C_COMPONENT_STATUS' to System State Machine component of SCC
         tU8 param1 = puchData[3];
         ETG_TRACE_ERRMEM( ( "SPM command 'SSM_C_COMPONENT_STATUS' was called: param1 = 0x%x", param1 ) );

         // SSM_C_COMPONENT_STATUS: user specific code start
         ETG_TRACE_USR4( ( "spm_tclSystemStateMachineServiceHandler::vHandleTraceMessage INC Message C_COMPONENT_STATUS : param1 = %u", \
                           ETG_ENUM( FD_SYSTEM_SM_SYSTEM_SM_APPLSTAT, (tU8)param1 ) ) );
         eSystemSm_ApplicationStatus eClientComponentStatus = (eSystemSm_ApplicationStatus)param1;
         vSetComponentStatus( eClientComponentStatus );
         // SSM_C_COMPONENT_STATUS: user specific code end
      }
      break;

      case SPM_SSM_C_SET_STATEMACHINE_TYPE:
      {
         // Trigger INC message 'C_SET_STATEMACHINE_TYPE' to System State Machine component of SCC
         tU8 param1 = puchData[3];
         ETG_TRACE_ERRMEM( ( "SPM command 'SSM_C_SET_STATEMACHINE_TYPE' was called: param1 = 0x%x", param1 ) );

         // SSM_C_SET_STATEMACHINE_TYPE: user specific code start
         ETG_TRACE_USR4( ( "spm_tclSystemStateMachineServiceHandler::vHandleTraceMessage INC Message C_SET_STATEMACHINE_TYPE: param1 = %u", \
                           ETG_ENUM( FD_SYSTEM_SM_SYSTEM_SM_STATEMACHINETYPE, (tU8)param1 ) ) );
         eSystemSm_StateMachineType eStateMachineType = (eSystemSm_StateMachineType)param1;
         bSetStateMachineType( eStateMachineType );
         // SSM_C_SET_STATEMACHINE_TYPE: user specific code end
      }
      break;

      case SPM_SSM_C_SET_SM_TRIGGER:
      {
         // Trigger INC message 'C_SET_SM_TRIGGER' to System State Machine component of SCC
         tU8 param1 = puchData[3];
         tU8 param2 = puchData[4];
         ETG_TRACE_ERRMEM( ( "SPM command 'SSM_C_SET_SM_TRIGGER' was called: param1 = 0x%x, param2 = 0x%x", param1, param2 ) );

         // SSM_C_SET_SM_TRIGGER: user specific code start
         ETG_TRACE_USR4( ( "spm_tclSystemStateMachineServiceHandler::vHandleTraceMessage INC Message C_SET_SM_TRIGGER: param1 = %u, param2 = %u", \
                           ETG_ENUM( FD_SYSTEM_SM_SYSTEM_SM_STATEMACHINETRIGGER, (tU8)param1 ), \
                           ETG_ENUM( FD_SYSTEM_SM_SYSTEM_SM_TRIGGERSTATE,       (tU8)param1 ) ) );
         eSystemSm_StateMachineTrigger eStateMachineTrigger = (eSystemSm_StateMachineTrigger)param1;
         eSystemSm_TriggerState        eTriggerState        = (eSystemSm_TriggerState)param2;
         bSetStateMachineTrigger( eStateMachineTrigger, eTriggerState );
         // SSM_C_SET_SM_TRIGGER: user specific code end
      }
      break;

      case SPM_SSM_C_SET_SCC_SYSTEMSTATE:
      {
         // Trigger INC message 'C_SET_SCC_SYSTEMSTATE' to System State Machine component of SCC
         tU8 param1 = puchData[3];
         ETG_TRACE_ERRMEM( ( "SPM command 'SSM_C_SET_SCC_SYSTEMSTATE' was called: param1 = 0x%x", param1 ) );

         // SSM_C_SET_SCC_SYSTEMSTATE: user specific code start
         ETG_TRACE_USR4( ( "spm_tclSystemStateMachineServiceHandler::vHandleTraceMessage INC Message C_SET_SCC_SYSTEMSTATE: param1 = %u", \
                           ETG_ENUM( FD_SYSTEM_SM_SYSTEM_SM_SCCSYSTEMSTATE, (tU8)param1 ) ) );
         eSystemSm_SccSystemState eSccSystemState = (eSystemSm_SccSystemState)param1;
         bSetSCCSystemState( eSccSystemState );
         // SSM_C_SET_SCC_SYSTEMSTATE: user specific code end
      }
      break;

      case SPM_SSM_C_SEND_APP_SYSTEMSTATE:
      {
         // Trigger INC message 'C_SEND_APP_SYSTEMSTATE' to System State Machine component of SCC
         tU8 param1 = puchData[3];
         ETG_TRACE_ERRMEM( ( "SPM command 'SSM_C_SEND_APP_SYSTEMSTATE' was called: param1 = 0x%x", param1 ) );

         // SSM_C_SEND_APP_SYSTEMSTATE: user specific code start
         ETG_TRACE_USR4( ( "spm_tclSystemStateMachineServiceHandler::vHandleTraceMessage INC Message C_SEND_APP_SYSTEMSTATE: param1 = %u", \
                           ETG_ENUM( FD_SYSTEM_SM_SYSTEM_SM_APPSYSTEMSTATE, (tU8)param1 ) ) );
         eSystemSm_AppSystemState eAppSystemState = (eSystemSm_AppSystemState)param1;
         bSetAppSystemState( eAppSystemState );
         // SSM_C_SEND_APP_SYSTEMSTATE: user specific code end
      }
      break;

      case SPM_SSM_CONNECT_FD:
      {
         // Trigger SSM Service Handler client to connect to FakedDevice server
         tU8 param1 = puchData[3];
         ETG_TRACE_ERRMEM( ( "SPM command 'SSM_CONNECT_FD' was called: param1 = 0x%x", param1 ) );

         // SSM_CONNECT_FD: user specific code start
         vSetupConnectionToFD( param1 );
         // SSM_CONNECT_FD: user specific code end
      }
      break;

      default:
         //nothing to do
         break;
   } //lint !e764: switch statement possibly does not have a case --> generated trace command function
     // spm_tclSystemStateMachineServiceHandlerFunction: user specific code start
     // spm_tclSystemStateMachineServiceHandlerFunction: user specific code end

   return;
} // vHandleTraceMessage

// Trace specific code can be put here
// spm_tclSystemStateMachineServiceHandlerFile: user specific code start
// spm_tclSystemStateMachineServiceHandlerFile: user specific code end

