/**
  * @swcomponent    Life Cycle Management
  * @{
  * @file           spm_SCCSocketInterface.h
  * @brief          This is header file for SCC socket interface.
  * @copyright      (C) 2013 -2016 Robert Bosch Engineering and Business Solutions Limited.
  *                 The reproduction, distribution and utilization of this file as well as the
  *                 communication of its contents to others without express authorization is prohibited.
  *                 Offenders will be held liable for the payment of damages.
  *                 All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include <string>
#include <unistd.h>
#include <sys/poll.h>
#include <sys/ioctl.h>
#include <netdb.h>

#include "spm_ISCCSocketInterface.h"
#include "DatagramSocket.h"
#define SCC_ERROR      -1
#define CONNECT_TO_CLIENT FALSE

/*!
  *  \class spm_tclSCCSocketInterface
  *  \brief This class establishes the socket interface to communicate with System Communication Controller through Inter Node Communication(INC).
  *         Moreover, it has a Receive(Rx) thread to receive the messages from System Communication Controller. Once a message is received, it invokes client handler's specific
  *         method(vProcessSCCMessage) to process the message received.
  *
  *         Any client handler which uses INC to communicate with System Communication Controller should extend this class and override the method - vProcessSCCMessage.
  *         This method should have all the logic to process the messages received from System Communication Controller specific to the client handler.
  *
  *         The client handlers - spm_tclThermalManagementServiceHandler and spm_tclSupplyManagementServiceHandler use this class to communicate with Vehicle Communication
  *         Controller.
  */

class spm_tclSCCSocketInterface : public ISpmSCCSocketInterface
                                       , public DatagramSocketCallbackIf
{
public:
spm_tclSCCSocketInterface( tU8                u8SocketFamily,
                           tS32               s32Portno );
virtual ~spm_tclSCCSocketInterface( );
tS32 s32SendToINCSocket( spm_tclSCCMessage *poSCCMessage );

private:
tU8 _u8SocketFamily;
tS32 _s32Portno;
//avoid copy
spm_tclSCCSocketInterface(const spm_tclSCCSocketInterface &corfoSCCSocketInterface);
//avoid assignment
spm_tclSCCSocketInterface & operator = (const spm_tclSCCSocketInterface &corfoSCCSocketInterface);

DatagramSocket* _poDatagramSocket;

void onNewDatagramMessage(void* data, size_t length);

protected:
void vSetupConnectionToFD( tU8 bIsConnectToFD );

};

