/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_LateServiceHandler.h
  * @brief        This is header file contains functions for LateServiceHandler.
  * @copyright    (C) 2015 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_ILateServiceHandler.h"
#include "IDbusProxy.h"

#define LCM_FI_S_IMPORT_INTERFACE_LCM_DBUSCTRLFI_STDVISITORS
#include "lcm_fi_if.h"
/******************************************************************************
  | local #define (scope: module-local)
  |-----------------------------------------------------------------------*/

// service handler requests ---------------------------------------
class ISpmCcaServiceServer;
// Startup Investigation
class ISpmStartupInvestigationServer;

class spm_tclSpmLateServiceHandler : public spm_ISpmLateServiceHandler
{
private:
// Property handler
tVoid vHandleStartProcessMResult( amt_tclServiceData *poMessage );

tVoid vHandleGetProcessIdMResult( amt_tclServiceData *poMessage );

// method handler
tVoid vHandleAppStartReqUpdate( amt_tclServiceData *poMessage );

tVoid vHandleAppInitUpdate( amt_tclServiceData *poMessage );

tVoid vHandleAppStateChangeUpdate( amt_tclServiceData *poMessage );

tVoid vHandleNewServiceLoadedUpdate( amt_tclServiceData *poMessage );

tVoid vHandleFailedServicesListUpdate( amt_tclServiceData *poMessage );

tVoid vHandleNewProcessIdUpdate( amt_tclServiceData *poMessage );

tVoid vHandleStartupFailureIndUpdate( amt_tclServiceData *poMessage );

ISpmCcaServiceServer            *_poclCcaServiceHandler;

ISpmStartupInvestigationServer  *_poclStartupInvest;

// flag indicate there is message left need to be sent to lcmLate
tBool                   _bMessageLeftToBeSend;

// Value of supervision 
tBool                   _bSupervisionActive;

// flag indicate procbaselate reaches sync point
tBool                   _bLcmLateStarted;

// contains the list of failed services
TServiceFailedEntryList _ServiceFailedEntryList;


protected:
// ISpmBase interface functions
virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual const tChar*getName( ) const { return( "spm_tclSpmLateServiceHandler" ); }
virtual tVoid vGetReferences( );

// virtual tVoid vStartCommunication(); parent method used

public:
spm_tclSpmLateServiceHandler( const ISpmFactory& factory );
virtual ~spm_tclSpmLateServiceHandler( );

virtual tVoid vRegisterFids( );

virtual tVoid vOnFirstServiceStateAvailable( );

tBool bStopProcess( const std::string& strLocation,
                    tU32               u32ProcId = 0 );
tBool bRestartProcess( const std::string& strLocation,
                    tU32               u32ProcId = 0 );


tVoid vSupervisionStateChange( tBool               bSupervisionActive = FALSE );

tS32  s32StartProcess( const std::string& strLocation,
                       tU32               u32Type = 0,
                       tU32               u32NiceLevel = 0,
                       tU32               u32NiceLevelEnd = 0,
                       tU32               u32Prio = 0,
                       tU32               u32Affinity = 0,
                       tU32               u32AffinityEnd = 0 );

tS32 s32AppStateChange( tU32 u32AppId,
                        tU32 u32State );

tVoid vGetProcessId( std::string strServiceName );

tVoid vStartupActivated( );

tVoid vTriggerGetFailedUnitList( );

virtual const TServiceFailedEntryList& GetUnitList( ) const { return( _ServiceFailedEntryList ); }

tBool bStartupReady( );

tBool bIsLcmLateStarted( );

private:
std::string strBuildStartupFailureMsg( const lcm_fi_tcl_StartupFailureInfo &failureInfo );
std::string strGetStartupStatusString( const lcm_fi_tcl_e32_LCM_STARTUP_TYPE &type );
std::string strGetStartupFailureString( const lcm_fi_tcl_e32_LCM_STARTUP_FAILURE_TYPE &type );

DECLARE_MSG_MAP( spm_tclSpmLateServiceHandler )

};

