/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ILateServiceHandler.h
  * @brief        This is header file contains interface functions for LateServiceHandler.
  * @copyright    (C) 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_ClientHandlerBase.h"

typedef struct TServiceFailedEntry
{
   std::string strServiceName;
   std::string strServiceDescription;
   std::string strServiceLoadState;
   std::string strServiceActiveState;
   std::string strServiceSubState;
   std::string strServiceFollower;
} TServiceFailedEntry;
typedef std::list < TServiceFailedEntry > TServiceFailedEntryList;

/******************************************************************************
  | local #define (scope: module-local)
  |-----------------------------------------------------------------------*/

// service handler requests ---------------------------------------
class ISpmCcaServiceServer;

class spm_ISpmLateServiceHandler : public spm_tclClientHandlerBase
{
private:
// Property handler
virtual tVoid vHandleStartProcessMResult( amt_tclServiceData *poMessage )      = 0;

virtual tVoid vHandleGetProcessIdMResult( amt_tclServiceData *poMessage )      = 0;

// method handler
virtual tVoid vHandleAppStartReqUpdate( amt_tclServiceData *poMessage )        = 0;

virtual tVoid vHandleAppInitUpdate( amt_tclServiceData *poMessage )            = 0;

virtual tVoid vHandleAppStateChangeUpdate( amt_tclServiceData *poMessage )     = 0;

virtual tVoid vHandleNewServiceLoadedUpdate( amt_tclServiceData *poMessage )   = 0;

virtual tVoid vHandleFailedServicesListUpdate( amt_tclServiceData *poMessage ) = 0;

virtual tVoid vHandleNewProcessIdUpdate( amt_tclServiceData *poMessage )       = 0;

virtual tVoid vHandleStartupFailureIndUpdate( amt_tclServiceData *poMessage )  = 0;

// contains the list of failed services
TServiceFailedEntryList _ServiceFailedEntryList;

protected:
// ISpmBase interface functions
virtual const tChar*getInterfaceName( ) const { return( "spm_ISpmLateServiceHandler" ); }

public:
spm_ISpmLateServiceHandler( const ISpmFactory& factory,
                            tU32               u32AppId,
                            tU16               u16SrvId,
                            tU16               u16MajorVersion,
                            tU16               u16MinorVersion ) : spm_tclClientHandlerBase( factory, u32AppId, u16SrvId, u16MajorVersion, u16MinorVersion ){}
virtual ~spm_ISpmLateServiceHandler( ){}

virtual tVoid vRegisterFids( )                                 = 0;

virtual tVoid vOnFirstServiceStateAvailable( )                 = 0;

virtual tBool bStopProcess( const std::string& strLocation,
                            tU32               u32ProcId = 0 ) = 0;
virtual tBool bRestartProcess( const std::string& strLocation,
                            tU32               u32ProcId = 0 ) = 0;


virtual tVoid vSupervisionStateChange( tBool               bSupervisionActive = FALSE ) = 0;

virtual tS32  s32StartProcess( const std::string& strLocation,
                               tU32               u32Type = 0,
                               tU32               u32NiceLevel = 0,
                               tU32               u32NiceLevelEnd = 0,
                               tU32               u32Prio = 0,
                               tU32               u32Affinity = 0,
                               tU32               u32AffinityEnd = 0 ) = 0;

virtual tS32 s32AppStateChange( tU32 u32AppId,
                                tU32 u32State )                        = 0;

virtual tVoid vGetProcessId( std::string strServiceName )              = 0;

virtual tVoid vStartupActivated( )                                     = 0;

virtual tVoid vTriggerGetFailedUnitList( )                             = 0;

virtual const TServiceFailedEntryList& GetUnitList( ) const { return( _ServiceFailedEntryList ); }

virtual tBool bStartupReady( )                                         = 0;

virtual tBool bIsLcmLateStarted( )                                     = 0;

};

