/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_IClientHandlerBase.h
  * @brief        This is header file contains interfaces to handle service functionalities.
  * @copyright    (C) 2013 - 2016 Robert Bosch Engineering and Business Solutions Limited.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#include "spm_ISpmBase.h"

/*!
  *  \class ISpmClientHandlerBase
  *  \brief This abstract class provides interfaces to handle service functionalities.
          This class supplies pure virtual functions to handle service status, on service message and service confirmation.
  */
class ISpmClientHandlerBase : public ahl_tclBaseWork
   , public ISpmBase
{

public:
ISpmClientHandlerBase( const ISpmFactory& factory ) : ISpmBase( factory ){}
virtual ~ISpmClientHandlerBase( ){ }

virtual tBool bRegisterServices( tU32 u32AppId )                                        = 0;

virtual tVoid vHandleServiceStatus( const amt_tclServiceStatus *poSrvStatus )           = 0;

virtual tBool bOnServiceDataMessage( amt_tclServiceData *poSrvData )                    = 0;

virtual tVoid vHandleServiceConfirmation( const amt_tclServiceRegisterConf *poSrvConf ) = 0;

virtual tVoid vOnServiceStateAvailable( )                                               = 0;

virtual const tChar*getName( ) const                                                    = 0;

virtual tVoid vRegisterFids( )                                                          = 0;

virtual tBool bIsServiceAvailable( ) const                                              = 0;

protected:
virtual tVoid  vOnUnknownMessage( amt_tclBaseMessage *poMessage )                       = 0;

virtual tVoid vUpRegFid( tU16 u16Fid )                                                  = 0;

public:
// ISpmBase interface functions
virtual tVoid vGetReferences( )                                                         = 0;

virtual tVoid vStartCommunication( )                                                    = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmClientHandlerBase" ); }

};

