/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ClientHandlerBase.h
  * @brief        This is header file contains functions for ClientHandlerBase.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_IClientHandlerBase.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#include "spm_ICcaServer.h"
#include <map>

#define U16_SPM_UPREG_COMMAND_COUNTER 65000

// //////////////////////////////////////////////////////////////////////////////
// class definition

/*!
  *  \class spm_tclClientHandlerBase
  *  \brief This is the client handler base class and derived from ISpmClientHandlerBase

          It is used to register the service and updates its status.
        It uses spm_tclCcaMsgHandler for posting AMT messages.

          The spm_tclFactory object creates an instance of this class.

          All service clienthandler classes needs to be derived  from this class for registering and starting purpose themselves .
  */
class spm_tclClientHandlerBase : public ISpmClientHandlerBase
{
public:
spm_tclClientHandlerBase( const ISpmFactory& factory,
                          tU32               u32AppId,
                          tU16               u16SrvId,
                          tU16               u16MajorVersion,
                          tU16               u16MinorVersion );
virtual ~spm_tclClientHandlerBase( );

virtual tBool bRegisterServices( tU32 u32AppId );

virtual tBool bUnRegisterServices( tU16 u16AppId );

virtual tVoid vHandleServiceStatus( const amt_tclServiceStatus *poSrvStatus );

virtual tBool bOnServiceDataMessage( amt_tclServiceData *poSrvData );

virtual tVoid vHandleServiceConfirmation( const amt_tclServiceRegisterConf *poSrvConf );

virtual tVoid vOnServiceStateAvailable( );

virtual tVoid vOnFirstServiceStateAvailable( );

virtual const tChar*getName( ) const = 0;

virtual tVoid vRegisterFids( );

virtual tVoid vUpRegStatusChange( tU16  u16Fid,
                                  tBool bStatus );

virtual tBool bIsServiceAvailable( ) const {
   return( _u8SrvState == AMT_C_U8_SVCSTATE_AVAILABLE );
}

protected:
// ISpmBase interface functions
virtual tVoid vGetReferences( );

virtual tVoid vStartCommunication( );

virtual tVoid  vOnUnknownMessage( amt_tclBaseMessage *poMessage );

virtual tVoid vUpRegFid( tU16 u16Fid );


tU16                     _u16RegID;
tU8                      _u8SrvState;
tU16                     _u16AppId;
tU16                     _u16SrvId;

tU16                     _u16MajorVersion;
tU16                     _u16MinorVersion;

tBool                    _bUpregSend;

ISpmCcaServer           *_poclCcaMsgHandler;

public:
std::map < tU16, tBool > _mapfids;
};

