/*!
  * \file spm_ApplicationRequestSupervisor.cpp
  *  \brief
  *    To supervise of application state requests
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  * 29.07.11  | TMS Fischer       | initial version
  ******
  */

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

// SPM  configuration
#include "spm_Config.h"

// my class header
#include "spm_ApplicationRequestSupervisor.h"

// interfaces class definitions
#include "spm_IApplicationDatabase.h"
#include "spm_ILocalAppManager.h"

#include "spm_IFactory.h"

// spm helper


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM_LAM
 #include "trcGenProj/Header/spm_ApplicationRequestSupervisor.cpp.trc.h"
#endif
// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

/******************************************************************************
  | local #define (scope: module-local)
  |-----------------------------------------------------------------------*/
// #define SPM_TRACE_FILE_ID   SPM_FILE_APPLICATIONREQUESTSUPERVISOR

spm_tclApplicationRequestSupervisor::spm_tclApplicationRequestSupervisor( const ISpmFactory& factory )
   : ISpmApplicationRequestSupervisor( factory )
   , _bThreadIsActive( FALSE )
   , _u32ActiveRequests( 0 )
   , _poclLocalAppManager( NULL )
   , _poclDb( NULL )
   , _poclWorkerServer( NULL ){
}

spm_tclApplicationRequestSupervisor::~spm_tclApplicationRequestSupervisor( ){
   _poclDb              = NULL;
   _poclLocalAppManager = NULL;
   _poclWorkerServer    = NULL;
}

tVoid spm_tclApplicationRequestSupervisor::vStartCommunication( ){
}

tVoid spm_tclApplicationRequestSupervisor::vGetReferences( ){
   SPM_GET_IF_REFERENCE_USE_VAR( _poclDb,              ISpmApplicationDatabase );
   SPM_GET_IF_REFERENCE_USE_VAR( _poclLocalAppManager, ISpmLocalAppManager );
   SPM_GET_IF_REFERENCE_USE_VAR( _poclWorkerServer,    ISpmWorkerServer );
}

tVoid spm_tclApplicationRequestSupervisor::vStartSupervision( ){
   if ( !_bThreadIsActive ){
      ETG_TRACE_USR4( ( "spm_tclApplicationRequestSupervisor::StartSupervision" ) );
      vResume( );
   }
}

tVoid spm_tclApplicationRequestSupervisor::main( ){
   // Check every 2s
   OSAL_s32ThreadWait( SPM_APPREQMON_CHECK_INTERVAL );

   SPM_NULL_POINTER_CHECK( _poclLocalAppManager );
   SPM_NULL_POINTER_CHECK( _poclWorkerServer );

   if ( bIsTerminated( ) ){
      return;
   }
   // check request by LocalApplicationManager and remember failed appId and failed state transition
   _poclLocalAppManager->vCheckForUnacknowledgedState( _u32ActiveRequests );

   // if no request is processing and startup check is finished, suspend the thread
   if ( _u32ActiveRequests == 0 ){
      ETG_TRACE_USR4( ( "spm_tclApplicationRequestSupervisor::StopSupervision" ) );
      _bThreadIsActive = FALSE;
      _poclWorkerServer->bPostMessageToWorker( SPM_U32_WORKER_LAM_APP_REQUEST_MON_STOPPED, 0 );
      vSuspend( );
   }
} // main

