/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ApplicationErrorHandler.h
  * @brief        This is header file contains functions for ApplicationErrorHandler.
  * @copyright    (C) 2015 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------
#include "spm_IApplicationErrorHandler.h"

#define SPM_APPERRHDL_TRIGGER_APP_ERROR        0
#define SPM_APPERRHDL_TRIGGER_RESET            1

class ISpmWorkerServer;

typedef struct TArrErrMsg
{
   tU32 u32Cmd;
   tU8 u8ErrmemType;
   tU8 u8ShutdownReason;
   tU32 u32ErrorType;
   union
   {
      struct
      {
         tU32 u32CurSystemState;
         tU32 u32NewSystemState;
         tU32 u32CurAppState;
         tU32 u32ReqAppState;
         tU32 u32AppId;
         tChar strExecPath[120];
         tChar strStartType[40];
      } tAppErr;
   }u;
} TArrErrMsg;

class spm_tclApplicationErrorHandler
   : public ISpmApplicationErrorHandler
{
private:

OSAL_tMQueueHandle _hAppErrQueue;

ISpmWorkerServer  *_poclWorkerServer;
tBool              _fWriteEmptyUnitFailedList;
tBool              _fUnitFailedListResultReceived;

protected:
virtual tBool bTriggerAppError( spm_tclConnectedApp app,
                                tU8                 u8ShutdownReason,
                                tU8                 u8ErrmemType,
                                tU32                u32ErrorType = 0 );

virtual tBool bTriggerReset( tU32 u32ResetType );

virtual tVoid vWriteAppThreadInfo( TArrErrMsg& tAppErrMsg );

virtual tVoid vWriteQueueStatus( const std::string& strName );

virtual tVoid vWriteAdditionalAppThreadInfo( tU32 u32AppId );

virtual tVoid vWriteApplicationErrorToErrmem( TArrErrMsg& tAppErrMsg );

virtual tVoid vWriteQueueFullToErrmem( TArrErrMsg& tAppErrMsg );

virtual tVoid vWriteApplicationQueueFullToErrmem( TArrErrMsg& tAppErrMsg );

virtual tVoid vTriggerServiceFileErrorsGet( );

virtual tVoid vWriteServiceFileErrorsToErrmem( tBool bWriteIfListEmpty );

virtual tVoid vWriteApplicationWdgErrorToErrmem( TArrErrMsg& tAppErrMsg );

// ISpmBase interface functions
virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual const tChar*getName( ) const { return( "spm_tclApplicationErrorHandler" ); }
virtual tVoid vStartCommunication( );

virtual tVoid vGetReferences( );

// overrides from spm_tclActive
virtual tVoid vOnStart( ){}
virtual tVoid vOnTerminate( ){}

// Implementation of interface ISpmWorkerClient
virtual tBool bHandleSynchrounousCall( tU32   /*u32Message*/,
                                       tVoid */*args*/ ){ return( FALSE ); } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual tVoid vHandleMessage( tU32 /*u32Message*/,
                              tU32 /*u32Parm = 0*/ ){}                       //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

public:
spm_tclApplicationErrorHandler( const ISpmFactory& factory );
virtual ~spm_tclApplicationErrorHandler( );

virtual tVoid main( );

virtual tVoid vStart( const std::string& strName,
                      tU32               u32Prio = 80,
                      tU32               u32Stack = 10000 );

virtual tVoid vStateChangeImmediately( spm_tclConnectedApp app,
                                       tBool               bRestart = FALSE );

virtual tVoid vStateChangeFailed( spm_tclConnectedApp app,
                                  tBool               bRestart = FALSE );

virtual tVoid vAppEndFailure( spm_tclConnectedApp app,
                              tU32                u32ErrorType,
                              tBool               bRestart = FALSE );

virtual tVoid vTerminateChangeFailed( spm_tclConnectedApp app,
                                      tBool               bRestart = FALSE );

virtual tVoid vWdgNotifyProblem( spm_tclConnectedApp app,
                                 tBool               bRestart = FALSE );

virtual tVoid vMsgQueueFull( spm_tclConnectedApp app,
                             tBool               bSender,
                             tBool               bRestart = FALSE );

virtual tVoid vMsgQueueFull( tU32  u32AppId,
                             tBool bSender,
                             tBool bRestart = FALSE );

virtual tVoid vGetUnitFailedList( );

virtual tVoid vTriggerUnitFailedListReceived( );

virtual tVoid vSetWriteEmptyUnitFailedList( tBool fWriteEmptyUnitLists ){ _fWriteEmptyUnitFailedList = fWriteEmptyUnitLists; }
virtual tBool fUnitFailedListResultReceived( ){ return( _fUnitFailedListResultReceived ); }
};

