/*!
  * \file  spm_ApplicationConfiguration_trace.cpp
  *  \brief
  *    Method definitions for testing via trace purposes.
  *               This list is generated.
  *
  *  \note
  *  PROJECT: NextGen
  *  SW-COMPONENT: FC SPM
  *  COPYRIGHT:    (C) 2013 - 2020 Robert Bosch GmbH, Hildesheim

  *  The reproduction, distribution and utilization of this file as
  *  well as the communication of its contents to others without express
  *  authorization is prohibited. Offenders will be held liable for the
  *  payment of damages. All rights reserved in the event of the grant
  *  of a patent, utility model or design.
  *
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "spm_Config.h"

// Trace specific includes can be put here
// spm_tclApplicationConfiguration_include_ext: user specific code start
// my class header
#include "spm_ApplicationConfiguration.h"
#include "spm_IApplicationErrorHandler.h"
#include "spm_IApplicationDatabase.h"

#include "spm_factory.h"
// my class header
// my class header
// spm_tclApplicationConfiguration_include_ext: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
#include "trcGenProj/Header/spm_ApplicationConfiguration_trace.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

// Spm trace specific code can be put here
// spm_tclApplicationConfiguration_include_spm: user specific code start
// spm_tclApplicationConfiguration_include_spm: user specific code end


tVoid spm_tclApplicationConfiguration::vHandleTraceMessage(const tUChar *puchData){
/*!
  * \fn
  *  \brief
  *    Interface function for the tracechannel.
  *
  *  \param[in]
  *    puchData - Trace command data.
  ******
  */
   tU32 u32MsgCode = ( puchData[1] << 8 ) | puchData[2];

   switch (u32MsgCode){

      case SPM_SPMGETAPPTHREADINFO:
      {
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);

         // SpmGetAppThreadInfo: user specific code start
            ETG_TRACE_USR4( ( "Store threadinfo in errmem..." ) );

         spm_tclConnectedApp *poConApp = NULL;
            SPM_NULL_POINTER_CHECK(_poclDb);
         poConApp = _poclDb->poGetByAppID(param1);
         if (poConApp){
            SPM_GET_IF_REFERENCE_NEW_VAR(poclAppErrHandler, ISpmApplicationErrorHandler);
            poclAppErrHandler->vStateChangeImmediately(* poConApp);
         } else {
            ETG_TRACE_FATAL( ( "SPM_SPMGETAPPTHREADINFO error! poGetByAppID(%d(=0x%X)) returned NULL!", param1, param1 ) );
         }
         // SpmGetAppThreadInfo: user specific code end
      }
      break;

      case SPM_SPMSETALLAPPLICATIONCONFIGURATIONS:
      {
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         tU16 param2 = (tU16)((puchData[7]<<8) | puchData[8]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmSetAllApplicationConfigurations' was called: param1 = 0x%x, param2 = 0x%x", param1, param2 ) );

         // SpmSetAllApplicationConfigurations: user specific code start
         vSetNewDefaultValue(param1, param2);
         // SpmSetAllApplicationConfigurations: user specific code end
      }
      break;

      case SPM_SPMSETAPPLICATIONCONFIGURATION:
      {
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         tU32 param2 = (tU32)((puchData[7]<<24) | (puchData[8]<<16) | (puchData[9]<<8) | puchData[10]);
         tU32 param3 = (tU32)((puchData[11]<<24) | (puchData[12]<<16) | (puchData[13]<<8) | puchData[14]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmSetApplicationConfiguration' was called: param1 = 0x%x, param2 = 0x%x, param3 = 0x%x", param1, param2, param3 ) );

         // SpmSetApplicationConfiguration: user specific code start
         vSetValue(param1, param2, param3);
         // SpmSetApplicationConfiguration: user specific code end
      }
      break;

      case SPM_SPMSETALTERNATIVEAPPLICATIONCONFIGURATIONPERSTRING:
      {
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         const tChar* pString2 = (const tChar*)&puchData[7];
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmSetAlternativeApplicationConfigurationPerString' was called: param1 = 0x%x, param2 = '%20s'", param1, (const tChar*)pString2 ) );

         // SpmSetAlternativeApplicationConfigurationPerString: user specific code start
         vSetNewStateConfiguration(param1, pString2);
         // SpmSetAlternativeApplicationConfigurationPerString: user specific code end
      }
      break;

      case SPM_SPMSETDEFAULTAPPLICATIONCONFIGURATION:
      {
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmSetDefaultApplicationConfiguration' was called: param1 = 0x%x", param1 ) );

         // SpmSetDefaultApplicationConfiguration: user specific code start
         vSetDefaultValue(param1);
         // SpmSetDefaultApplicationConfiguration: user specific code end
      }
      break;

      case SPM_SPMSHOWAPPLICATIONCONFIGURATION:
      {
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);

         // SpmShowApplicationConfiguration: user specific code start
         vTraceInfo(param1);
         // SpmShowApplicationConfiguration: user specific code end
      }
      break;

      default:
         //nothing to do
         break;
   } //lint !e764: switch statement possibly does not have a case --> generated trace command function
     // spm_tclApplicationConfigurationFunction: user specific code start
     // spm_tclApplicationConfigurationFunction: user specific code end

   return;
} // vHandleTraceMessage

// Trace specific code can be put here
// spm_tclApplicationConfigurationFile: user specific code start
// spm_tclApplicationConfigurationFile: user specific code end

