#ifndef _LCMCCADBUSGW_SERVERLCMDBUSFI_H
#define _LCMCCADBUSGW_SERVERLCMDBUSFI_H

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          lcmccadbusgw_ServiceLcmDbusFi.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: lcmccadbusgateway
  * @Template:     FrancaStub.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                CCA server
  *
  *                Do manual changes only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2020 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#include <iostream>

#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"
#include "asf/core/Timer.h"

#include "org/bosch/cm/lcm_dbus_fi/lcm_dbus_fi_serviceStub.h"

#include "asf/stream/MemoryStream.h"

#include "Ilcmccadbusgw_ServiceLcmDbusFi.h"

// lcmccadbusgw_ServerLcmDbusFiInclude: user specific code start
// lcmccadbusgw_ServerLcmDbusFiInclude: user specific code end

namespace org { namespace bosch { namespace cm { namespace lcmccadbusgw {

    using namespace::asf::core;
    using namespace::asf::stream;
    using namespace::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service;
    using namespace::asf::core;
    using namespace::org::bosch::cm::lcmccadbusgw;

    // lcmccadbusgw_ServerLcmDbusFiNameSpace: user specific code start
    // lcmccadbusgw_ServerLcmDbusFiNameSpace: user specific code end

    class lcmccadbusgw_tclServerLcmDbusFi : public Ilcmccadbusgw_tclServerLcmDbusFi
        , private Lcm_dbus_fi_serviceStub
        , private TimerCallbackIF
   {
    private:
        DECLARE_CLASS_LOGGER();

    public:
        lcmccadbusgw_tclServerLcmDbusFi(lcmccadbusgw_tclAppMain* baseRef);
        virtual ~lcmccadbusgw_tclServerLcmDbusFi();


       virtual void onSystemModeRequest(const ::boost::shared_ptr< SystemModeRequest >& payload);

       virtual void onDownloadLockStateRequest(const ::boost::shared_ptr< DownloadLockStateRequest >& payload);

       virtual void onUpdateLockRequest(const ::boost::shared_ptr< UpdateLockRequest >& payload);

       virtual void onOnOffTriggerRequest(const ::boost::shared_ptr< OnOffTriggerRequest >& payload);

       virtual void onStartProcessRequest(const ::boost::shared_ptr< StartProcessRequest >& payload);

       virtual void onStopProcessRequest(const ::boost::shared_ptr< StopProcessRequest >& payload);

       virtual void onRestartProcessRequest(const ::boost::shared_ptr< RestartProcessRequest >& payload);

       virtual void onStartUpSyncPointReachedRequest(const ::boost::shared_ptr< StartUpSyncPointReachedRequest >& payload);

       virtual void onClearListRequest(const ::boost::shared_ptr< ClearListRequest >& payload);

       virtual void onRestartSystemRequest(const ::boost::shared_ptr< RestartSystemRequest >& payload);

       virtual void onAudioSourceChangeRequest(const ::boost::shared_ptr< AudioSourceChangeRequest >& payload);

       virtual void onChangeBluetoothStateRequest(const ::boost::shared_ptr< ChangeBluetoothStateRequest >& payload);

       virtual void onChangeAudioStateRequest(const ::boost::shared_ptr< ChangeAudioStateRequest >& payload);

       virtual void onChangeSpiStateRequest(const ::boost::shared_ptr< ChangeSpiStateRequest >& payload);

       virtual void onChangeTunerStateRequest(const ::boost::shared_ptr< ChangeTunerStateRequest >& payload);

       virtual void onChangeWifiStateRequest(const ::boost::shared_ptr< ChangeWifiStateRequest >& payload);

       virtual void onShutdownAndTerminateCcaAppsRequest(const ::boost::shared_ptr< ShutdownAndTerminateCcaAppsRequest >& payload);

       virtual void onSetFactorySettingsNewRequest(const ::boost::shared_ptr< SetFactorySettingsNewRequest >& payload);

       virtual void onClearVINRequest(const ::boost::shared_ptr< ClearVINRequest >& payload);

       virtual void onPrepareDownloadRequest(const ::boost::shared_ptr< PrepareDownloadRequest >& payload);

       virtual void onEndDownloadRequest(const ::boost::shared_ptr< EndDownloadRequest >& payload);

       virtual void onSetOnConfigurationRequest(const ::boost::shared_ptr< SetOnConfigurationRequest >& payload);

       virtual void onSetProcessConfigurationRequest(const ::boost::shared_ptr< SetProcessConfigurationRequest >& payload);

       virtual void onEntertainDeMuteRequest(const ::boost::shared_ptr< EntertainDeMuteRequest >& payload);

       virtual void onEntertainMuteRequestRequest(const ::boost::shared_ptr< EntertainMuteRequestRequest >& payload);

       virtual void onWelcomeAudioActivationRequest(const ::boost::shared_ptr< WelcomeAudioActivationRequest >& payload);


    public:
        virtual const tChar* getName() const { return "lcmccadbusgw_tclServerLcmDbusFi"; }

        virtual tVoid vHandleMessage(lcmccadbusgw_tclBaseIf::TMsg* pMsg);
        virtual tVoid vHandleTraceMessage(const tUChar* /*puchData*/) {}
        virtual tVoid vGetReferences();
        virtual tVoid vStartCommunication();
        virtual tVoid vTraceInfo();

        virtual tVoid setSystemStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_SYSTEM_STATES& SystemState) {
            Lcm_dbus_fi_serviceStub::setSystemState(SystemState);
        }
        virtual tVoid setDownloadLockStatesValue(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_RestrictedDlLock >& DownloadLockStates) {
            Lcm_dbus_fi_serviceStub::setDownloadLockStates(DownloadLockStates);
        }
        virtual tVoid setUpdateLockStatesValue(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_UpdateLockState >& UpdateLockStates) {
            Lcm_dbus_fi_serviceStub::setUpdateLockStates(UpdateLockStates);
        }
        virtual tVoid setActiveOnOffTriggerValue(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_SubStateType >& ActiveOnOffTrigger) {
            Lcm_dbus_fi_serviceStub::setActiveOnOffTrigger(ActiveOnOffTrigger);
        }
        virtual tVoid setSubStatesValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::TSubStates& SubStates) {
            Lcm_dbus_fi_serviceStub::setSubStates(SubStates);
        }
        virtual tVoid setHistoryTriggerValue(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_HistoryTrigger >& HistoryTrigger) {
            Lcm_dbus_fi_serviceStub::setHistoryTrigger(HistoryTrigger);
        }
        virtual tVoid setInsertStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_CD_INSERT_STATE& InsertState) {
            Lcm_dbus_fi_serviceStub::setInsertState(InsertState);
        }
        virtual tVoid setMediaEjectStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_MEDIA_EJECT_STATE& MediaEjectState) {
            Lcm_dbus_fi_serviceStub::setMediaEjectState(MediaEjectState);
        }
        virtual tVoid setPhoneMuteStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_PHONE_MUTE_STATE& PhoneMuteState) {
            Lcm_dbus_fi_serviceStub::setPhoneMuteState(PhoneMuteState);
        }
        virtual tVoid setOnTipperStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_KEY_STATE& OnTipperState) {
            Lcm_dbus_fi_serviceStub::setOnTipperState(OnTipperState);
        }
        virtual tVoid setIgnitionCyclesValue(const tU32& IgnitionCycles) {
            Lcm_dbus_fi_serviceStub::setIgnitionCycles(IgnitionCycles);
        }
        virtual tVoid setSysPwrModeValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_SYSPWRMODE& SysPwrMode) {
            Lcm_dbus_fi_serviceStub::setSysPwrMode(SysPwrMode);
        }
        virtual tVoid setSysPwrSaveModeValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_b32_SYSPWRSAVEMODE& SysPwrSaveMode) {
            Lcm_dbus_fi_serviceStub::setSysPwrSaveMode(SysPwrSaveMode);
        }
        virtual tVoid setMapDownloadLockStateValue(const tU16& MapDownloadLockState) {
            Lcm_dbus_fi_serviceStub::setMapDownloadLockState(MapDownloadLockState);
        }
        virtual tVoid setStandbyTimeValue(const tU32& StandbyTime) {
            Lcm_dbus_fi_serviceStub::setStandbyTime(StandbyTime);
        }
        virtual tVoid setPersitentStandbyTimeValue(const tU32& PersitentStandbyTime) {
            Lcm_dbus_fi_serviceStub::setPersitentStandbyTime(PersitentStandbyTime);
        }
        virtual tVoid setIgnitionOffTimeValue(const tU32& IgnitionOffTime) {
            Lcm_dbus_fi_serviceStub::setIgnitionOffTime(IgnitionOffTime);
        }
        virtual tVoid setDoorOpenTimeValue(const tU32& DoorOpenTime) {
            Lcm_dbus_fi_serviceStub::setDoorOpenTime(DoorOpenTime);
        }
        virtual tVoid setClockDisplayTimeValue(const tU32& ClockDisplayTime) {
            Lcm_dbus_fi_serviceStub::setClockDisplayTime(ClockDisplayTime);
        }
        virtual tVoid setSystemStateTimeValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::TSystemStateTime& SystemStateTime) {
            Lcm_dbus_fi_serviceStub::setSystemStateTime(SystemStateTime);
        }
        virtual tVoid setProcessListValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_ProcessInfo& ProcessList) {
            Lcm_dbus_fi_serviceStub::setProcessList(ProcessList);
        }
        virtual tVoid setWakeupReasonValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_WAKEUP_REASON& WakeupReason) {
            Lcm_dbus_fi_serviceStub::setWakeupReason(WakeupReason);
        }
        virtual tVoid setStartupReasonValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_STARTUP_REASON& StartupReason) {
            Lcm_dbus_fi_serviceStub::setStartupReason(StartupReason);
        }
        virtual tVoid setConnectToBatteryValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::TConnectToBattery& ConnectToBattery) {
            Lcm_dbus_fi_serviceStub::setConnectToBattery(ConnectToBattery);
        }
        virtual tVoid setCodeRequestStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_CODE_REQUEST& CodeRequestState) {
            Lcm_dbus_fi_serviceStub::setCodeRequestState(CodeRequestState);
        }
        virtual tVoid setActiveStartUpSyncPointsValue(const ::std::vector< ::std::string >& ActiveStartUpSyncPoints) {
            Lcm_dbus_fi_serviceStub::setActiveStartUpSyncPoints(ActiveStartUpSyncPoints);
        }
        virtual tVoid setCvmEventValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_CVM_EVENT& CvmEvent) {
            Lcm_dbus_fi_serviceStub::setCvmEvent(CvmEvent);
        }
        virtual tVoid setUBatSenseValue(const tU16& UBatSense) {
            Lcm_dbus_fi_serviceStub::setUBatSense(UBatSense);
        }
        virtual tVoid setCoproStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_PROCESSOR_STATE& CoproState) {
            Lcm_dbus_fi_serviceStub::setCoproState(CoproState);
        }
        virtual tVoid setDevicePowerOnTimeValue(const tU32& DevicePowerOnTime) {
            Lcm_dbus_fi_serviceStub::setDevicePowerOnTime(DevicePowerOnTime);
        }
        virtual tVoid setLastSystemRuntimeValue(const tU32& LastSystemRuntime) {
            Lcm_dbus_fi_serviceStub::setLastSystemRuntime(LastSystemRuntime);
        }
        virtual tVoid setCurrentSystemRuntimeValue(const tU32& CurrentSystemRuntime) {
            Lcm_dbus_fi_serviceStub::setCurrentSystemRuntime(CurrentSystemRuntime);
        }
        virtual tVoid setResetListValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::TResetList& ResetList) {
            Lcm_dbus_fi_serviceStub::setResetList(ResetList);
        }
        virtual tVoid setResetCounterValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::TResetCounter& ResetCounter) {
            Lcm_dbus_fi_serviceStub::setResetCounter(ResetCounter);
        }
        virtual tVoid setTransportModeListValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_TransPortModeList& TransportModeList) {
            Lcm_dbus_fi_serviceStub::setTransportModeList(TransportModeList);
        }
        virtual tVoid setResetHistoryValue(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_ResetElement >& ResetHistory) {
            Lcm_dbus_fi_serviceStub::setResetHistory(ResetHistory);
        }
        virtual tVoid setWakeupHistoryValue(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_WakeupElement >& WakeupHistory) {
            Lcm_dbus_fi_serviceStub::setWakeupHistory(WakeupHistory);
        }
        virtual tVoid setStateHistoryValue(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_StateChangeElement >& StateHistory) {
            Lcm_dbus_fi_serviceStub::setStateHistory(StateHistory);
        }
        virtual tVoid setErrStateHistory01Value(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_StateChangeElement >& ErrStateHistory01) {
            Lcm_dbus_fi_serviceStub::setErrStateHistory01(ErrStateHistory01);
        }
        virtual tVoid setErrStateHistory02Value(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_StateChangeElement >& ErrStateHistory02) {
            Lcm_dbus_fi_serviceStub::setErrStateHistory02(ErrStateHistory02);
        }
        virtual tVoid setErrStateHistory03Value(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_StateChangeElement >& ErrStateHistory03) {
            Lcm_dbus_fi_serviceStub::setErrStateHistory03(ErrStateHistory03);
        }
        virtual tVoid setErrStateHistory04Value(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_StateChangeElement >& ErrStateHistory04) {
            Lcm_dbus_fi_serviceStub::setErrStateHistory04(ErrStateHistory04);
        }
        virtual tVoid setErrStateHistory05Value(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_StateChangeElement >& ErrStateHistory05) {
            Lcm_dbus_fi_serviceStub::setErrStateHistory05(ErrStateHistory05);
        }
        virtual tVoid setSwitchOnHistoryValue(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SwitchOnElement >& SwitchOnHistory) {
            Lcm_dbus_fi_serviceStub::setSwitchOnHistory(SwitchOnHistory);
        }
        virtual tVoid setDeviceOnCounterValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::TDeviceOnCounter& DeviceOnCounter) {
            Lcm_dbus_fi_serviceStub::setDeviceOnCounter(DeviceOnCounter);
        }
        virtual tVoid setVoltageEventCounterValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_VoltageEventCounter& VoltageEventCounter) {
            Lcm_dbus_fi_serviceStub::setVoltageEventCounter(VoltageEventCounter);
        }
        virtual tVoid setVoltageRangeHistogramValue(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_VoltageRange >& VoltageRangeHistogram) {
            Lcm_dbus_fi_serviceStub::setVoltageRangeHistogram(VoltageRangeHistogram);
        }
        virtual tVoid setCpuUsageStatisticValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_SystemStatisticsData& CpuUsageStatistic) {
            Lcm_dbus_fi_serviceStub::setCpuUsageStatistic(CpuUsageStatistic);
        }
        virtual tVoid setRamUsageStatisticValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_SystemStatisticsData& RamUsageStatistic) {
            Lcm_dbus_fi_serviceStub::setRamUsageStatistic(RamUsageStatistic);
        }
        virtual tVoid setStartupTimeStatisticValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_SystemStatisticsData& StartupTimeStatistic) {
            Lcm_dbus_fi_serviceStub::setStartupTimeStatistic(StartupTimeStatistic);
        }
        virtual tVoid setRunlevelStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_RUNLEVEL& RunlevelState) {
            Lcm_dbus_fi_serviceStub::setRunlevelState(RunlevelState);
        }
        virtual tVoid setRestartValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_RESTART_TYPE& Restart) {
            Lcm_dbus_fi_serviceStub::setRestart(Restart);
        }
        virtual tVoid setLifesignValue(const tU32& Lifesign) {
            Lcm_dbus_fi_serviceStub::setLifesign(Lifesign);
        }
        virtual tVoid setHmiStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_HMI_STATE& HmiState) {
            Lcm_dbus_fi_serviceStub::setHmiState(HmiState);
        }
        virtual tVoid setSystemPowerBehaviourValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_SYSPWR_BEHAVIOUR& SystemPowerBehaviour) {
            Lcm_dbus_fi_serviceStub::setSystemPowerBehaviour(SystemPowerBehaviour);
        }
        virtual tVoid setDimStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_DIM_STATE& DimState) {
            Lcm_dbus_fi_serviceStub::setDimState(DimState);
        }
        virtual tVoid setDimmingStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_b32_DIM_STATE& DimmingState) {
            Lcm_dbus_fi_serviceStub::setDimmingState(DimmingState);
        }
        virtual tVoid setBluetoothStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_BT_STATE& BluetoothState) {
            Lcm_dbus_fi_serviceStub::setBluetoothState(BluetoothState);
        }
        virtual tVoid setAudioStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_AUDIO_STATE& AudioState) {
            Lcm_dbus_fi_serviceStub::setAudioState(AudioState);
        }
        virtual tVoid setSpiStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_SPI_STATE& SpiState) {
            Lcm_dbus_fi_serviceStub::setSpiState(SpiState);
        }
        virtual tVoid setTunerStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_TUNER_STATE& TunerState) {
            Lcm_dbus_fi_serviceStub::setTunerState(TunerState);
        }
        virtual tVoid setWifiStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_WIFI_STATE& WifiState) {
            Lcm_dbus_fi_serviceStub::setWifiState(WifiState);
        }
        virtual tVoid setOnOffReasonValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_OnOffReason& OnOffReason) {
            Lcm_dbus_fi_serviceStub::setOnOffReason(OnOffReason);
        }
        virtual tVoid setWakeupListValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::TWakeupList& WakeupList) {
            Lcm_dbus_fi_serviceStub::setWakeupList(WakeupList);
        }
        virtual tVoid setStartupFinishedValue(const tBool& StartupFinished) {
            Lcm_dbus_fi_serviceStub::setStartupFinished(StartupFinished);
        }
        virtual tVoid setSysStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_SYS_STATE& SysState) {
            Lcm_dbus_fi_serviceStub::setSysState(SysState);
        }
        virtual tVoid setMostStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::TMostState& MostState) {
            Lcm_dbus_fi_serviceStub::setMostState(MostState);
        }
        virtual tVoid setMostVersionValue(const ::std::string& MostVersion) {
            Lcm_dbus_fi_serviceStub::setMostVersion(MostVersion);
        }
        virtual tVoid setRVCStateValue(const tBool& RVCState) {
            Lcm_dbus_fi_serviceStub::setRVCState(RVCState);
        }
        virtual tVoid setTriggerMostRemoteResetValue(const tU32& TriggerMostRemoteReset) {
            Lcm_dbus_fi_serviceStub::setTriggerMostRemoteReset(TriggerMostRemoteReset);
        }
        virtual tVoid setPartnumberValue(const tU32& Partnumber) {
            Lcm_dbus_fi_serviceStub::setPartnumber(Partnumber);
        }
        virtual tVoid setPartnumbersValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_PartnumberList& Partnumbers) {
            Lcm_dbus_fi_serviceStub::setPartnumbers(Partnumbers);
        }
        virtual tVoid setAlphacodeValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::TAlphacode& Alphacode) {
            Lcm_dbus_fi_serviceStub::setAlphacode(Alphacode);
        }
        virtual tVoid setAlphacodesValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_AlphacodeList& Alphacodes) {
            Lcm_dbus_fi_serviceStub::setAlphacodes(Alphacodes);
        }
        virtual tVoid setManufacturersEnableCounterValue(const tU8& ManufacturersEnableCounter) {
            Lcm_dbus_fi_serviceStub::setManufacturersEnableCounter(ManufacturersEnableCounter);
        }
        virtual tVoid setNoCalibrationStateValue(const tBool& NoCalibrationState) {
            Lcm_dbus_fi_serviceStub::setNoCalibrationState(NoCalibrationState);
        }
        virtual tVoid setSecurityCommErrorValue(const tU16& SecurityCommError) {
            Lcm_dbus_fi_serviceStub::setSecurityCommError(SecurityCommError);
        }
        virtual tVoid setSecurityMoreThan10VinValue(const tU16& SecurityMoreThan10Vin) {
            Lcm_dbus_fi_serviceStub::setSecurityMoreThan10Vin(SecurityMoreThan10Vin);
        }
        virtual tVoid setSecurityInvalidVinValue(const tU16& SecurityInvalidVin) {
            Lcm_dbus_fi_serviceStub::setSecurityInvalidVin(SecurityInvalidVin);
        }
        virtual tVoid setSecurityCurrentVinValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_Vin& SecurityCurrentVin) {
            Lcm_dbus_fi_serviceStub::setSecurityCurrentVin(SecurityCurrentVin);
        }
        virtual tVoid setSecurityVinHistoryValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_VinHistory& SecurityVinHistory) {
            Lcm_dbus_fi_serviceStub::setSecurityVinHistory(SecurityVinHistory);
        }
        virtual tVoid setVINValue(const ::std::string& VIN) {
            Lcm_dbus_fi_serviceStub::setVIN(VIN);
        }
        virtual tVoid setSecurityStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_SECURITY_STATE& SecurityState) {
            Lcm_dbus_fi_serviceStub::setSecurityState(SecurityState);
        }
        virtual tVoid setVehicleIDValue(const tU32& VehicleID) {
            Lcm_dbus_fi_serviceStub::setVehicleID(VehicleID);
        }
        virtual tVoid setDisplayVariantValue(const tU32& DisplayVariant) {
            Lcm_dbus_fi_serviceStub::setDisplayVariant(DisplayVariant);
        }
        virtual tVoid setReductionLevelValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_REDUCTION_LEVEL& ReductionLevel) {
            Lcm_dbus_fi_serviceStub::setReductionLevel(ReductionLevel);
        }
        virtual tVoid setStartupStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_STARTUP_STATE& StartupState) {
            Lcm_dbus_fi_serviceStub::setStartupState(StartupState);
        }
        virtual tVoid setEntertainMuteValue(const tBool& EntertainMute) {
            Lcm_dbus_fi_serviceStub::setEntertainMute(EntertainMute);
        }
        virtual tVoid setWelcomeAudioStateValue(const tBool& WelcomeAudioState) {
            Lcm_dbus_fi_serviceStub::setWelcomeAudioState(WelcomeAudioState);
        }
        virtual tVoid setUnballastTimeFromEngineStoppedValue(const tU32& UnballastTimeFromEngineStopped) {
            Lcm_dbus_fi_serviceStub::setUnballastTimeFromEngineStopped(UnballastTimeFromEngineStopped);
        }
        virtual tVoid setUnballastTimeBeforeUnballastValue(const tU32& UnballastTimeBeforeUnballast) {
            Lcm_dbus_fi_serviceStub::setUnballastTimeBeforeUnballast(UnballastTimeBeforeUnballast);
        }
        virtual tVoid setUnballastWarningTimeValue(const tU32& UnballastWarningTime) {
            Lcm_dbus_fi_serviceStub::setUnballastWarningTime(UnballastWarningTime);
        }
        virtual tVoid setDegradedCountValue(const tU32& DegradedCount) {
            Lcm_dbus_fi_serviceStub::setDegradedCount(DegradedCount);
        }
        virtual tVoid setDegradedTimeValue(const tU32& DegradedTime) {
            Lcm_dbus_fi_serviceStub::setDegradedTime(DegradedTime);
        }
        virtual tVoid setPhoneHandoverWarnTimeValue(const tU32& PhoneHandoverWarnTime) {
            Lcm_dbus_fi_serviceStub::setPhoneHandoverWarnTime(PhoneHandoverWarnTime);
        }

        // TimerCallbackIF
        virtual void onExpired(asf::core::Timer                          & timer,
                               boost::shared_ptr <asf::core::TimerPayload> payload);

        virtual tVoid sendSystemModeResp(tS32& s32ReturnValOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendSystemModeResponse(s32ReturnValOut, act);
        }
        virtual tVoid sendSystemModeErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendSystemModeError(errorName, errorMessage, act);
        }
        virtual tVoid sendDownloadLockStateResp(tS32& s32ReturnValOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendDownloadLockStateResponse(s32ReturnValOut, act);
        }
        virtual tVoid sendDownloadLockStateErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendDownloadLockStateError(errorName, errorMessage, act);
        }
        virtual tVoid sendUpdateLockResp(tS32& s32ReturnValOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendUpdateLockResponse(s32ReturnValOut, act);
        }
        virtual tVoid sendUpdateLockErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendUpdateLockError(errorName, errorMessage, act);
        }
        virtual tVoid sendOnOffTriggerResp(tS32& s32ResOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendOnOffTriggerResponse(s32ResOut, act);
        }
        virtual tVoid sendOnOffTriggerErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendOnOffTriggerError(errorName, errorMessage, act);
        }
        virtual tVoid sendStartProcessResp(tS32& s32ReturnValOut, ::std::string& strLocationOut, tU32& u32ProcIdOut, tU32& u32SpawnDurationOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendStartProcessResponse(s32ReturnValOut, strLocationOut, u32ProcIdOut, u32SpawnDurationOut, act);
        }
        virtual tVoid sendStartProcessErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendStartProcessError(errorName, errorMessage, act);
        }
        virtual tVoid sendStopProcessResp(tS32& s32ReturnValOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendStopProcessResponse(s32ReturnValOut, act);
        }
        virtual tVoid sendStopProcessErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendStopProcessError(errorName, errorMessage, act);
        }
        virtual tVoid sendRestartProcessResp(tS32& s32ReturnValOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendRestartProcessResponse(s32ReturnValOut, act);
        }
        virtual tVoid sendRestartProcessErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendRestartProcessError(errorName, errorMessage, act);
        }
        virtual tVoid sendStartUpSyncPointReachedResp(tS32& s32ResOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendStartUpSyncPointReachedResponse(s32ResOut, act);
        }
        virtual tVoid sendStartUpSyncPointReachedErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendStartUpSyncPointReachedError(errorName, errorMessage, act);
        }
        virtual tVoid sendClearListResp(tS32& s32ResOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendClearListResponse(s32ResOut, act);
        }
        virtual tVoid sendClearListErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendClearListError(errorName, errorMessage, act);
        }
        virtual tVoid sendRestartSystemResp(::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_MRESULT& e32ReturnValOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendRestartSystemResponse(e32ReturnValOut, act);
        }
        virtual tVoid sendRestartSystemErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendRestartSystemError(errorName, errorMessage, act);
        }
        virtual tVoid sendAudioSourceChangeResp(tS32& s32ResOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendAudioSourceChangeResponse(s32ResOut, act);
        }
        virtual tVoid sendAudioSourceChangeErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendAudioSourceChangeError(errorName, errorMessage, act);
        }
        virtual tVoid sendChangeBluetoothStateResp(tS32& s32ResOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendChangeBluetoothStateResponse(s32ResOut, act);
        }
        virtual tVoid sendChangeBluetoothStateErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendChangeBluetoothStateError(errorName, errorMessage, act);
        }
        virtual tVoid sendChangeAudioStateResp(tS32& s32ResOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendChangeAudioStateResponse(s32ResOut, act);
        }
        virtual tVoid sendChangeAudioStateErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendChangeAudioStateError(errorName, errorMessage, act);
        }
        virtual tVoid sendChangeSpiStateResp(tS32& s32ResOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendChangeSpiStateResponse(s32ResOut, act);
        }
        virtual tVoid sendChangeSpiStateErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendChangeSpiStateError(errorName, errorMessage, act);
        }
        virtual tVoid sendChangeTunerStateResp(tS32& s32ResOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendChangeTunerStateResponse(s32ResOut, act);
        }
        virtual tVoid sendChangeTunerStateErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendChangeTunerStateError(errorName, errorMessage, act);
        }
        virtual tVoid sendChangeWifiStateResp(tS32& s32ResOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendChangeWifiStateResponse(s32ResOut, act);
        }
        virtual tVoid sendChangeWifiStateErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendChangeWifiStateError(errorName, errorMessage, act);
        }
        virtual tVoid sendShutdownAndTerminateCcaAppsResp(tS32& s32ResOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendShutdownAndTerminateCcaAppsResponse(s32ResOut, act);
        }
        virtual tVoid sendShutdownAndTerminateCcaAppsErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendShutdownAndTerminateCcaAppsError(errorName, errorMessage, act);
        }
        virtual tVoid sendSetFactorySettingsNewResp(::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_e8_DiaglogDefsetType& DefSetStateGroupOut, ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_e8_DefSetMode& DefSetStateModeOut, tBool& DefSetStateSuccessfulOut, tU16& DefSetStateFirstDifferentParameterIdOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendSetFactorySettingsNewResponse(DefSetStateGroupOut, DefSetStateModeOut, DefSetStateSuccessfulOut, DefSetStateFirstDifferentParameterIdOut, act);
        }
        virtual tVoid sendSetFactorySettingsNewErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendSetFactorySettingsNewError(errorName, errorMessage, act);
        }
        virtual tVoid sendClearVINResp(tU32& ResultOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendClearVINResponse(ResultOut, act);
        }
        virtual tVoid sendClearVINErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendClearVINError(errorName, errorMessage, act);
        }
        virtual tVoid sendPrepareDownloadResp(tU32& ResultOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendPrepareDownloadResponse(ResultOut, act);
        }
        virtual tVoid sendPrepareDownloadErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendPrepareDownloadError(errorName, errorMessage, act);
        }
        virtual tVoid sendEndDownloadResp(tU32& ResultOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendEndDownloadResponse(ResultOut, act);
        }
        virtual tVoid sendEndDownloadErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendEndDownloadError(errorName, errorMessage, act);
        }
        virtual tVoid sendSetOnConfigurationResp(tU32& ResultOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendSetOnConfigurationResponse(ResultOut, act);
        }
        virtual tVoid sendSetOnConfigurationErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendSetOnConfigurationError(errorName, errorMessage, act);
        }
        virtual tVoid sendSetProcessConfigurationResp(tU32& ResultOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendSetProcessConfigurationResponse(ResultOut, act);
        }
        virtual tVoid sendSetProcessConfigurationErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendSetProcessConfigurationError(errorName, errorMessage, act);
        }
        virtual tVoid sendEntertainDeMuteResp(tS32& s32ReturnValOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendEntertainDeMuteResponse(s32ReturnValOut, act);
        }
        virtual tVoid sendEntertainDeMuteErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendEntertainDeMuteError(errorName, errorMessage, act);
        }
        virtual tVoid sendEntertainMuteRequestResp(tS32& s32ReturnValOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendEntertainMuteRequestResponse(s32ReturnValOut, act);
        }
        virtual tVoid sendEntertainMuteRequestErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendEntertainMuteRequestError(errorName, errorMessage, act);
        }
        virtual tVoid sendWelcomeAudioActivationResp(tS32& s32ReturnValOut, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendWelcomeAudioActivationResponse(s32ReturnValOut, act);
        }
        virtual tVoid sendWelcomeAudioActivationErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) {
            Lcm_dbus_fi_serviceStub::sendWelcomeAudioActivationError(errorName, errorMessage, act);
        }

        // lcmccadbusgw_ServerLcmDbusFiDeclarationsPart: user specific code start
        // lcmccadbusgw_ServerLcmDbusFiDeclarationsPart: user specific code end
    };

}}}} // namespace org { namespace bosch { namespace cm { namespace lcmccadbusgw {

#endif // ifndef _LCMCCADBUSGW_SERVERLCMDBUSFI_H

