/*****************************************************************************
 * @file:         lcmccadbusgw_ServiceLcmDbusFi.cpp
 * @PROJECT:      CMD project
 * @SW-COMPONENT: lcmccadbusgateway
 * @Template:     FrancaStub.cpp.tpl
 * ----------------------------------------------------------------------------
 *
 * @brief:  generated file
 *          CCA server
 *
 *          Do manual changes only inside tags
 *
 *          //......................: user specific code start 
 *          //......................: user specific code end 
 *
 * ----------------------------------------------------------------------------
 * @copyright   (c) 2020 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 *****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#define ETG_S_IMPORT_INTERFACE_PLATFORM
#include "etg_if.h"

#include "lcmccadbusgw_ServiceLcmDbusFi.h"

#include "lcmccadbusgwDbus2CcaWrapperlcm_dbus_fi.h"
#include "Ilcmccadbusgw_ClientSpm.h"

// lcmccadbusgw_ServerLcmDbusFiIncludePart: user specific code start
// lcmccadbusgw_ServerLcmDbusFiIncludePart: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LCMCCADBUSGATEWAY_SERVER_LCMDBUSFI
#include "trcGenProj/Header/lcmccadbusgw_ServiceLcmDbusFi.cpp.trc.h"
#endif


namespace org { namespace bosch { namespace cm { namespace lcmccadbusgw {

using namespace::asf::core;
using namespace::asf::stream;
using namespace::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service;

DEFINE_CLASS_LOGGER_AND_LEVEL("org/bosch/cm/Lcmccadbusgw/lcmccadbusgw_tclServerLcmDbusFi", lcmccadbusgw_tclServerLcmDbusFi, Info);


lcmccadbusgw_tclServerLcmDbusFi::lcmccadbusgw_tclServerLcmDbusFi(lcmccadbusgw_tclAppMain* baseRef)
   : Ilcmccadbusgw_tclServerLcmDbusFi(baseRef)
   , Lcm_dbus_fi_serviceStub("LcmDbusFiFiPort")
{
   LOG_INFO("Constructor for lcmccadbusgw_tclServerLcmDbusFi called");
   ETG_TRACE_USR1( ( "Constructor for lcmccadbusgw_tclServerLcmDbusFi called" ) );
   
   // lcmccadbusgw_ServerLcmDbusFilcmccadbusgw_tclServerLcmDbusFi: user specific code start
   // lcmccadbusgw_ServerLcmDbusFilcmccadbusgw_tclServerLcmDbusFi: user specific code end
}

lcmccadbusgw_tclServerLcmDbusFi::~lcmccadbusgw_tclServerLcmDbusFi(){
   LOG_INFO("~lcmccadbusgw_tclServerLcmDbusFi called");
   ETG_TRACE_USR1( ( "~lcmccadbusgw_tclServerLcmDbusFi called" ) );
}

// TimerCallbackIF
void lcmccadbusgw_tclServerLcmDbusFi::onExpired(asf::core::Timer& timer, boost::shared_ptr <asf::core::TimerPayload> payload){
   // lcmccadbusgw_ServerLcmDbusFionExpired: user specific code start
   (tVoid)timer;
   (tVoid)payload;
   // lcmccadbusgw_ServerLcmDbusFionExpired: user specific code end
}


void lcmccadbusgw_tclServerLcmDbusFi::onSystemModeRequest (const ::boost::shared_ptr< SystemModeRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onSystemModeRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendSystemModeStart(oConvertDbusToCca_T_e8_StateModes(request->getESystemMode()));

   actSystemModeQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionSystemModeRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionSystemModeRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onDownloadLockStateRequest (const ::boost::shared_ptr< DownloadLockStateRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onDownloadLockStateRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendDownloadLockStateStart(
                               request->getStrRestrictedDlState(), 
                               oConvertDbusToCca_T_e8_DownloadLockStates(request->getERestrictedDlMode()));

   actDownloadLockStateQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionDownloadLockStateRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionDownloadLockStateRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onUpdateLockRequest (const ::boost::shared_ptr< UpdateLockRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onUpdateLockRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendUpdateLockStart(
                               request->getStrLockName(), 
                               oConvertDbusToCca_T_e8_UpdateLockCommand(request->getELockRequest()));

   actUpdateLockQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionUpdateLockRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionUpdateLockRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onOnOffTriggerRequest (const ::boost::shared_ptr< OnOffTriggerRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onOnOffTriggerRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendOnOffTriggerStart(
                               oConvertDbusToCca_T_SPM_e32_SubStateType(request->getESwitchOnTrigger()), 
                               request->getBState());

   actOnOffTriggerQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionOnOffTriggerRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionOnOffTriggerRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onStartProcessRequest (const ::boost::shared_ptr< StartProcessRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onStartProcessRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendStartProcessStart(
                               request->getStrLocation(), 
                               request->getU32Prio(), 
                               request->getU32Affinity(), 
                               request->getU32AffinityEnd(), 
                               request->getU32NiceLevel(), 
                               request->getU32NiceLevelEnd(), 
                               oConvertDbusToCca_T_SPM_e32_START_PROC_TYPE(request->getU32Type()), 
                               request->getU32Info());

   actStartProcessQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionStartProcessRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionStartProcessRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onStopProcessRequest (const ::boost::shared_ptr< StopProcessRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onStopProcessRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendStopProcessStart(
                               request->getStrLocation(), 
                               request->getU32ProcId());

   actStopProcessQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionStopProcessRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionStopProcessRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onRestartProcessRequest (const ::boost::shared_ptr< RestartProcessRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onRestartProcessRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendRestartProcessStart(
                               request->getStrLocation(), 
                               request->getU32ProcId());

   actRestartProcessQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionRestartProcessRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionRestartProcessRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onStartUpSyncPointReachedRequest (const ::boost::shared_ptr< StartUpSyncPointReachedRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onStartUpSyncPointReachedRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendStartUpSyncPointReachedStart(request->getStrNewSyncPoint());

   actStartUpSyncPointReachedQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionStartUpSyncPointReachedRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionStartUpSyncPointReachedRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onClearListRequest (const ::boost::shared_ptr< ClearListRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onClearListRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendClearListStart(oConvertDbusToCca_T_SPM_e32_CLEAR_LIST(request->getEList2Clear()));

   actClearListQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionClearListRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionClearListRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onRestartSystemRequest (const ::boost::shared_ptr< RestartSystemRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onRestartSystemRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendRestartSystemStart(oConvertDbusToCca_T_SPM_e32_RESTART_TYPE(request->getERestartType()));

   actRestartSystemQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionRestartSystemRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionRestartSystemRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onAudioSourceChangeRequest (const ::boost::shared_ptr< AudioSourceChangeRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onAudioSourceChangeRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendAudioSourceChangeStart(oConvertDbusToCca_T_SPM_e32_AUDIO_SOURCE(request->getEAudioSrc()));

   actAudioSourceChangeQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionAudioSourceChangeRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionAudioSourceChangeRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onChangeBluetoothStateRequest (const ::boost::shared_ptr< ChangeBluetoothStateRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onChangeBluetoothStateRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendChangeBluetoothStateStart(oConvertDbusToCca_T_SPM_e32_BT_STATE(request->getBtState()));

   actChangeBluetoothStateQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionChangeBluetoothStateRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionChangeBluetoothStateRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onChangeAudioStateRequest (const ::boost::shared_ptr< ChangeAudioStateRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onChangeAudioStateRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendChangeAudioStateStart(oConvertDbusToCca_T_SPM_e32_AUDIO_STATE(request->getAudioState()));

   actChangeAudioStateQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionChangeAudioStateRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionChangeAudioStateRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onChangeSpiStateRequest (const ::boost::shared_ptr< ChangeSpiStateRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onChangeSpiStateRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendChangeSpiStateStart(oConvertDbusToCca_T_SPM_e32_SPI_STATE(request->getSpiState()));

   actChangeSpiStateQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionChangeSpiStateRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionChangeSpiStateRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onChangeTunerStateRequest (const ::boost::shared_ptr< ChangeTunerStateRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onChangeTunerStateRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendChangeTunerStateStart(oConvertDbusToCca_T_SPM_e32_TUNER_STATE(request->getTunerState()));

   actChangeTunerStateQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionChangeTunerStateRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionChangeTunerStateRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onChangeWifiStateRequest (const ::boost::shared_ptr< ChangeWifiStateRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onChangeWifiStateRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendChangeWifiStateStart(oConvertDbusToCca_T_SPM_e32_WIFI_STATE(request->getWiFiState()));

   actChangeWifiStateQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionChangeWifiStateRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionChangeWifiStateRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onShutdownAndTerminateCcaAppsRequest (const ::boost::shared_ptr< ShutdownAndTerminateCcaAppsRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onShutdownAndTerminateCcaAppsRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendShutdownAndTerminateCcaAppsStart(oConvertDbusToCca_T_SPM_AppIdList(request->getTAppIdList()));

   actShutdownAndTerminateCcaAppsQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionShutdownAndTerminateCcaAppsRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionShutdownAndTerminateCcaAppsRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onSetFactorySettingsNewRequest (const ::boost::shared_ptr< SetFactorySettingsNewRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onSetFactorySettingsNewRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendSetFactorySettingsNewStart(
                               oConvertDbusToCca_T_e8_DiaglogDefsetType(request->getDefSetStateGroup()), 
                               oConvertDbusToCca_T_e8_DefSetMode(request->getDefSetStateMode()));

   actSetFactorySettingsNewQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionSetFactorySettingsNewRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionSetFactorySettingsNewRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onClearVINRequest (const ::boost::shared_ptr< ClearVINRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onClearVINRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendClearVINStart();

   actClearVINQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionClearVINRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionClearVINRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onPrepareDownloadRequest (const ::boost::shared_ptr< PrepareDownloadRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onPrepareDownloadRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendPrepareDownloadStart(
                               request->getConfiguration(), 
                               request->getSuspendBusShutdown(), 
                               request->getTimeout());

   actPrepareDownloadQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionPrepareDownloadRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionPrepareDownloadRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onEndDownloadRequest (const ::boost::shared_ptr< EndDownloadRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onEndDownloadRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendEndDownloadStart();

   actEndDownloadQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionEndDownloadRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionEndDownloadRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onSetOnConfigurationRequest (const ::boost::shared_ptr< SetOnConfigurationRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onSetOnConfigurationRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendSetOnConfigurationStart(request->getConfiguration());

   actSetOnConfigurationQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionSetOnConfigurationRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionSetOnConfigurationRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onSetProcessConfigurationRequest (const ::boost::shared_ptr< SetProcessConfigurationRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onSetProcessConfigurationRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendSetProcessConfigurationStart(request->getConfiguration());

   actSetProcessConfigurationQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionSetProcessConfigurationRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionSetProcessConfigurationRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onEntertainDeMuteRequest (const ::boost::shared_ptr< EntertainDeMuteRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onEntertainDeMuteRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendEntertainDeMuteStart();

   actEntertainDeMuteQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionEntertainDeMuteRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionEntertainDeMuteRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onEntertainMuteRequestRequest (const ::boost::shared_ptr< EntertainMuteRequestRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onEntertainMuteRequestRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendEntertainMuteRequestStart();

   actEntertainMuteRequestQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionEntertainMuteRequestRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionEntertainMuteRequestRequest: user specific code end
}

void lcmccadbusgw_tclServerLcmDbusFi::onWelcomeAudioActivationRequest (const ::boost::shared_ptr< WelcomeAudioActivationRequest >& request) {
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclServerLcmDbusFi::onWelcomeAudioActivationRequest(): CALLED" ) );

   Ilcmccadbusgw_tclClientSpm* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclClientSpm*>(_cpoMain->getHandler("Ilcmccadbusgw_tclClientSpm"));
   if (poDbusSrv) poDbusSrv->sendWelcomeAudioActivationStart(request->getBActivateState());

   actWelcomeAudioActivationQueue.push( request->getAct() );
   // lcmccadbusgw_ServerLcmDbusFionWelcomeAudioActivationRequest: user specific code start
   // lcmccadbusgw_ServerLcmDbusFionWelcomeAudioActivationRequest: user specific code end
}


tVoid lcmccadbusgw_tclServerLcmDbusFi::vHandleMessage(lcmccadbusgw_tclBaseIf::TMsg* pMsg) {
   // lcmccadbusgw_ServerLcmDbusFivHandleMessage: user specific code start
   (tVoid)pMsg;
   // lcmccadbusgw_ServerLcmDbusFivHandleMessage: user specific code end
}

tVoid lcmccadbusgw_tclServerLcmDbusFi::vGetReferences() {
   // lcmccadbusgw_ServerLcmDbusFivGetReferences: user specific code start
   // lcmccadbusgw_ServerLcmDbusFivGetReferences: user specific code end
}

tVoid lcmccadbusgw_tclServerLcmDbusFi::vStartCommunication() {
   // lcmccadbusgw_ServerLcmDbusFivStartCommunication: user specific code start
   // lcmccadbusgw_ServerLcmDbusFivStartCommunication: user specific code end
}

tVoid lcmccadbusgw_tclServerLcmDbusFi::vTraceInfo() {
   // lcmccadbusgw_ServerLcmDbusFivTraceInfo: user specific code start
   // lcmccadbusgw_ServerLcmDbusFivTraceInfo: user specific code end
}

// lcmccadbusgw_ServerLcmDbusFiDefinitioPart: user specific code start
// lcmccadbusgw_ServerLcmDbusFiDefinitioPart: user specific code end

}}}} // namespace org { namespace bosch { namespace cm { namespace lcmccadbusgw {

