/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         StartupControllerComponent.h
  * @brief        Implementation of the StartupControllerComponent component
  * @copyright    (C) 2015 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#define SYSTEMD_IMPORT_INTERFACE_GENERIC
#include "asf/core/BaseComponent.h"
#include "asf/core/Timer.h"
#include "asf/core/Logger.h"
#include "org/bosch/cm/lcm/startupcontrollerStub.h"
#include "org/freedesktop/systemd1/ServiceProxy.h"
#include <functional>
#include <vector>
#include <string>
// \todo: boost::shared_ptr is used here cause by ASF interface.
namespace org {
namespace bosch {
namespace cm  {
namespace lcm {
namespace startupcontroller {

using namespace ::asf::core;
using namespace ::org::bosch::cm::lcm;
using namespace ::org::freedesktop::systemd1::Service;

struct IsDigit : public std::unary_function < char, bool >
{
   bool operator()( const char& ch ) const { return( std::isdigit( static_cast < unsigned char >( ch ) ) ); }
};

class StartupControllerComponent
   : public BaseComponent
// Stub interface
   , private StartupcontrollerStub
// Timer interface
   , private TimerCallbackIF
// systemd Service Proxy
   , private TimeoutStartUSecCallbackIF
   , private ServiceAvailableIF
{
private:
DECLARE_CLASS_LOGGER( );

enum CliParamType
{
   StartupTimeType = 0,
   CliParamTypeMax
};

struct CliParamItem
{
   CliParamType Type;
   std::string KeyString;
};

StartupState startupStatus;
uint32 _StartupTimeSec;
Timer _StartupTimeEmergencyTimer;
Timer _TimeoutStartTimer;
uint32 _TimeoutStartUSec;
uint32 _PreTimeoutStartSec;
std::string _ServiceName;

// Supported command-line Parameters
static const CliParamItem _SupportedCliParams[];

public:
StartupControllerComponent( );
virtual ~StartupControllerComponent( );

// *************
// StartupControllerStub
// *************
// attribute FI_Version
virtual void onFI_VersionGet( const ::boost::shared_ptr < FI_VersionGet >& payload );

// attribute StartupState
virtual void onStartupStatusGet( const ::boost::shared_ptr < StartupStatusGet >& payload );

virtual void onStartupStatusSet( const ::boost::shared_ptr < StartupStatusSet >& payload );

// *************
// Timer
// *************
// TimerCallbackIF implementation
virtual void onExpired( asf::core::Timer                            & timer,
                        boost::shared_ptr < asf::core::TimerPayload > payload );

// Callback 'TimeoutStartUSecCallbackIF'

virtual void onTimeoutStartUSecError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< TimeoutStartUSecError >& error);

virtual void onTimeoutStartUSecUpdate(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< TimeoutStartUSecUpdate >& update);

// ServiceAvailableIF implementation
virtual void onAvailable( const boost::shared_ptr < Proxy >& proxy, const ServiceStateChange         & stateChange );

virtual void onUnavailable( const boost::shared_ptr < Proxy >& proxy, const ServiceStateChange         & stateChange );

private:

std::string     unitNameEscape( const std::string UnitName );

void StopStartupController( void );

void ProcessCommandLineArguments( const std::vector < std::string >& arguments );

CliParamType GetParamType( std::string argument );

::boost::shared_ptr < ServiceProxy > _serviceProxy;

};

}
}
}
}
}

