/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         LcmRecoveryClientComponent.h
  * @brief        Implementation of the GenericrecoveryClient component
  * @copyright    (C) 2013 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "asf/core/BaseComponent.h"
#include "asf/core/Timer.h"
#include "asf/core/Logger.h"
#include "org/bosch/cm/lcm/Generic_RecoveryClientProxy.h"
#include "org/freedesktop/systemd1/UnitProxy.h"
#include "org/freedesktop/systemd1/ServiceProxy.h"
#include "org/freedesktop/systemd1/ManagerProxy.h"

#include "GenericRecoveryClientComponent.h"
// \todo: boost::shared_ptr is used here cause by ASF interface.
namespace org {
namespace bosch {
namespace cm  {
namespace lcm {
namespace genericrecoveryclient {

using namespace ::asf::core;
using namespace ::org::bosch::cm::lcm;
using namespace ::org::bosch::cm::lcm::genericrecoveryclient;
using namespace ::org::bosch::cm::lcm::Generic_RecoveryClient;
using namespace ::org::freedesktop::systemd1::Unit;
using namespace ::org::freedesktop::systemd1::Service;
using namespace ::org::freedesktop::systemd1::Manager;

class LcmRecoveryClientComponent : public GenericRecoveryClientComponent
{
private:
DECLARE_CLASS_LOGGER( );

protected:
public:
LcmRecoveryClientComponent( );
virtual ~LcmRecoveryClientComponent( );


// ServiceAvailableIF implementation
virtual void onAvailable( const boost::shared_ptr < Proxy >& proxy,
                          const ServiceStateChange         & stateChange );

virtual void onUnavailable( const boost::shared_ptr < Proxy >& proxy,
                            const ServiceStateChange         & stateChange );

// *************
// UserCallbacks
// *************
// use this function to implement any task that needs to be done cyclically
virtual void _onActiveStateUpdate( const ::boost::shared_ptr < UnitProxy >        & proxy,
                                   const ::boost::shared_ptr < ActiveStateUpdate >& update,
                                   uint8                                            CallStackSignalCounter );

virtual void _onActiveStateError( const ::boost::shared_ptr < UnitProxy >       & proxy,
                                  const ::boost::shared_ptr < ActiveStateError >& error,
                                  uint8                                           CallStackSignalCounter );

// *************
// Timer
// *************
// TimerCallbackIF implementation
virtual void onExpired( asf::core::Timer                            & timer,
                        boost::shared_ptr < asf::core::TimerPayload > payload );

private:
int iCounter;
};

}
}
}
}
}

