/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         GenericRecoveryClientComponent.h
  * @brief        Implementation of the GenericrecoveryClient component
  * @copyright    (C) 2013 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#include "OsalConf.h"
#include "Linux_osal.h"
#include "lcm_Config.h"


#include "asf/core/BaseComponent.h"
#include "asf/core/Timer.h"
#include "asf/core/Logger.h"
#include "org/bosch/cm/lcm/Generic_RecoveryClientProxy.h"
#include "org/freedesktop/systemd1/UnitProxy.h"
#include "org/freedesktop/systemd1/ServiceProxy.h"
#include "org/freedesktop/systemd1/ManagerProxy.h"
// \todo: boost::shared_ptr is used here cause by ASF interface.
namespace org {
namespace bosch {
namespace cm  {
namespace lcm {
namespace genericrecoveryclient {

using namespace ::asf::core;
using namespace ::org::bosch::cm::lcm;
using namespace ::org::bosch::cm::lcm::Generic_RecoveryClient;
using namespace ::org::freedesktop::systemd1::Unit;
using namespace ::org::freedesktop::systemd1::Service;
using namespace ::org::freedesktop::systemd1::Manager;

class AsfManagerProxy
{
public:
uint32 _u32JobNewRegisterId;
uint32 _u32JobRemovedRegisterId;

AsfManagerProxy( )
   : _u32JobNewRegisterId( 0 ),
   _u32JobRemovedRegisterId( 0 ){}
};

class GenericRecoveryClientComponent : public
   #ifndef LCM_UNIT_TESTS
      BaseComponent
      , private ServiceAvailableIF
   #endif
// systemd ManagerProxy
   , private JobNewCallbackIF
   , private JobRemovedCallbackIF
   , private GetUnitCallbackIF
   , private StartUnitCallbackIF
   , private StopUnitCallbackIF
   , private ListJobsCallbackIF
// systemd UnitProxy
   , private ActiveStateCallbackIF
   , private IdCallbackIF
// systemd ServiceProxy
   , private ExecMainPIDCallbackIF
// LcmRecoveryClient
// properties
   , private FailedServiceNameCallbackIF
   , private FailedServiceStatusCallbackIF
   , private CallStackRequestCounterCallbackIF
   , private ActionRequestCallbackIF
// methods
   , private SetFailedServiceNameCallbackIF
   , private SetFailedServiceStatusCallbackIF
   , private SetCallStackRequestCounterCallbackIF
   , private CheckResetConditionCallbackIF
// Timer
   , private TimerCallbackIF
{
private:
DECLARE_CLASS_LOGGER( );

uint32 _SystemdNotifyTimeMSec;
Timer _SystemdNotifyTimer;
UnitStates _ServiceState;
UnitActions _ServiceAction;
int32 _CallStackSignal;
uint32 _ExecMainPid;
uint8 _CallStackSignalCounter;
bool _managerProxyAvailable;
bool _unitProxyAvailable;
bool _serviceProxyAvailable;
bool _lcmRecoveryClientProxyAvailable;
bool _genericRecoveryClientResetAllowed;

protected:
std::string _ServiceName;
Timer _CheckTimer;

std::string     unitNameEscape( const std::string UnitName );

bool            bIsOsalProcess( );

void            vSendCallstackSignalToAllTasksOfProc( const uint32 u32ProcessId );

public:
GenericRecoveryClientComponent( );
virtual ~GenericRecoveryClientComponent( );


// ServiceAvailableIF implementation
virtual void onAvailable( const boost::shared_ptr < Proxy >& proxy,
                          const ServiceStateChange         & stateChange );

virtual void onUnavailable( const boost::shared_ptr < Proxy >& proxy,
                            const ServiceStateChange         & stateChange );

// *************
// UserCallbacks
// *************
// use this function to implement any task that needs to be done cyclically
virtual void _onActiveStateUpdate( const ::boost::shared_ptr < UnitProxy >        & proxy,
                                   const ::boost::shared_ptr < ActiveStateUpdate >& update,
                                   uint8                                            CallStackSignalCounter );

virtual void _onActiveStateError( const ::boost::shared_ptr < UnitProxy >       & proxy,
                                  const ::boost::shared_ptr < ActiveStateError >& error,
                                  uint8                                           CallStackSignalCounter );


// *************
// systemd ManagerProxy
// *************
// JobNewCallbackIF implementation
virtual void onJobNewSignal( const ::boost::shared_ptr < ManagerProxy >& proxy,
                             const ::boost::shared_ptr < JobNewSignal >& pSignal );

virtual void onJobNewError( const ::boost::shared_ptr < ManagerProxy >& proxy,
                            const ::boost::shared_ptr < JobNewError > & error );

// JobRemovedCallbackIF implementation
virtual void onJobRemovedSignal( const ::boost::shared_ptr < ManagerProxy >    & proxy,
                                 const ::boost::shared_ptr < JobRemovedSignal >& pSignal );

virtual void onJobRemovedError( const ::boost::shared_ptr < ManagerProxy >   & proxy,
                                const ::boost::shared_ptr < JobRemovedError >& error );

// GetUnitCallbackIF implementation
virtual void onGetUnitResponse( const ::boost::shared_ptr < ManagerProxy >   & proxy,
                                const ::boost::shared_ptr < GetUnitResponse >& response );

virtual void onGetUnitError( const ::boost::shared_ptr < ManagerProxy >& proxy,
                             const ::boost::shared_ptr < GetUnitError >& error );

// StartUnitCallbackIF implementation
virtual void onStartUnitResponse( const ::boost::shared_ptr < ManagerProxy >     & proxy,
                                  const ::boost::shared_ptr < StartUnitResponse >& response );

virtual void onStartUnitError( const ::boost::shared_ptr < ManagerProxy >  & proxy,
                               const ::boost::shared_ptr < StartUnitError >& error );

// StopUnitCallbackIF implementation
virtual void onStopUnitResponse( const ::boost::shared_ptr < ManagerProxy >    & proxy,
                                 const ::boost::shared_ptr < StopUnitResponse >& response );

virtual void onStopUnitError( const ::boost::shared_ptr < ManagerProxy > & proxy,
                              const ::boost::shared_ptr < StopUnitError >& error );

// ListJobsCallbackIF implementation
virtual void onListJobsResponse( const ::boost::shared_ptr < ManagerProxy >    & proxy,
                                 const ::boost::shared_ptr < ListJobsResponse >& response );

virtual void onListJobsError( const ::boost::shared_ptr < ManagerProxy > & proxy,
                              const ::boost::shared_ptr < ListJobsError >& error );

// **********
// systemd UnitProxy
// **********
// ActiveStateCallbackIF implementation
virtual void onActiveStateUpdate( const ::boost::shared_ptr < UnitProxy >        & proxy,
                                  const ::boost::shared_ptr < ActiveStateUpdate >& update );

virtual void onActiveStateError( const ::boost::shared_ptr < UnitProxy >       & proxy,
                                 const ::boost::shared_ptr < ActiveStateError >& error );

// IdCallbackIF implementation
virtual void onIdUpdate( const ::boost::shared_ptr < UnitProxy >& proxy,
                         const ::boost::shared_ptr < IdUpdate > & update );

virtual void onIdError( const ::boost::shared_ptr < UnitProxy >& proxy,
                        const ::boost::shared_ptr < IdError >  & error );

// **********
// systemd ServiceProxy
// **********
// ExecMainPIDCallbackIF implementation
virtual void onExecMainPIDUpdate( const ::boost::shared_ptr < ServiceProxy >     & proxy,
                                  const ::boost::shared_ptr < ExecMainPIDUpdate >& update );

virtual void onExecMainPIDError( const ::boost::shared_ptr < ServiceProxy >    & proxy,
                                 const ::boost::shared_ptr < ExecMainPIDError >& error );

// *************
// Generic_RecoveryClientProxy
// *************
// FailedServiceNameCallbackIF implementation
virtual void onFailedServiceNameUpdate( const ::boost::shared_ptr < Generic_RecoveryClientProxy >& proxy,
                                        const ::boost::shared_ptr < FailedServiceNameUpdate >    & update );

virtual void onFailedServiceNameError( const ::boost::shared_ptr < Generic_RecoveryClientProxy >& proxy,
                                       const ::boost::shared_ptr < FailedServiceNameError >     & error );

// FailedServiceStatusCallbackIF implementation
virtual void onFailedServiceStatusUpdate( const ::boost::shared_ptr < Generic_RecoveryClientProxy >& proxy,
                                          const ::boost::shared_ptr < FailedServiceStatusUpdate >  & update );

virtual void onFailedServiceStatusError( const ::boost::shared_ptr < Generic_RecoveryClientProxy >& proxy,
                                         const ::boost::shared_ptr < FailedServiceStatusError >   & error );

// CallStackRequestCounterCallbackIF implementation
virtual void onCallStackRequestCounterUpdate( const ::boost::shared_ptr < Generic_RecoveryClientProxy >  & proxy,
                                              const ::boost::shared_ptr < CallStackRequestCounterUpdate >& update );

virtual void onCallStackRequestCounterError( const ::boost::shared_ptr < Generic_RecoveryClientProxy > & proxy,
                                             const ::boost::shared_ptr < CallStackRequestCounterError >& error );

// ActionRequestCallbackIF implementation
virtual void onActionRequestUpdate( const ::boost::shared_ptr < Generic_RecoveryClientProxy >& proxy,
                                    const ::boost::shared_ptr < ActionRequestUpdate >        & update );

virtual void onActionRequestError( const ::boost::shared_ptr < Generic_RecoveryClientProxy >& proxy,
                                   const ::boost::shared_ptr < ActionRequestError >         & error );

// SetFailedServiceNameCallbackIF implementation
virtual void onSetFailedServiceNameResponse( const ::boost::shared_ptr < Generic_RecoveryClientProxy > & proxy,
                                             const ::boost::shared_ptr < SetFailedServiceNameResponse >& response );

virtual void onSetFailedServiceNameError( const ::boost::shared_ptr < Generic_RecoveryClientProxy >& proxy,
                                          const ::boost::shared_ptr < SetFailedServiceNameError >  & error );

// SetFailedServiceStatusCallbackIF implementation
virtual void onSetFailedServiceStatusResponse( const ::boost::shared_ptr < Generic_RecoveryClientProxy >   & proxy,
                                               const ::boost::shared_ptr < SetFailedServiceStatusResponse >& response );

virtual void onSetFailedServiceStatusError( const ::boost::shared_ptr < Generic_RecoveryClientProxy >& proxy,
                                            const ::boost::shared_ptr < SetFailedServiceStatusError >& error );

// SetCallStackRequestCounterCallbackIF implementation
virtual void onSetCallStackRequestCounterResponse( const ::boost::shared_ptr < Generic_RecoveryClientProxy >       & proxy,
                                                   const ::boost::shared_ptr < SetCallStackRequestCounterResponse >& response );

virtual void onSetCallStackRequestCounterError( const ::boost::shared_ptr < Generic_RecoveryClientProxy >    & proxy,
                                                const ::boost::shared_ptr < SetCallStackRequestCounterError >& error );

virtual void onCheckResetConditionResponse( const ::boost::shared_ptr < Generic_RecoveryClientProxy >& proxy,
                                            const ::boost::shared_ptr < CheckResetConditionResponse >& response );

virtual void onCheckResetConditionError( const ::boost::shared_ptr < Generic_RecoveryClientProxy >& proxy,
                                         const ::boost::shared_ptr < CheckResetConditionError >   & error );

// *************
// Timer
// *************
// TimerCallbackIF implementation
virtual void onExpired( asf::core::Timer                            & timer,
                        boost::shared_ptr < asf::core::TimerPayload > payload );

protected:
::boost::shared_ptr < Generic_RecoveryClientProxy > _lcmRecoveryClientProxy;
::boost::shared_ptr < ManagerProxy > _managerProxy;
::boost::shared_ptr < UnitProxy > _unitProxy;
::boost::shared_ptr < ServiceProxy > _serviceProxy;

AsfManagerProxy _asfManagerProxy;
};

}
}
}
}
}

