/*****************************************************************************
  * (c) Robert Bosch Car Multimedia GmbH
  *
  * THIS FILE IS GENERATED. DO NOT EDIT.
  * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
  ****************************************************************************/

#pragma once

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include <dbus/dbus.h>

// \todo: boost::shared_ptr is used here cause by ASF interface.

using namespace ::asf::core;
using namespace ::asf::stream;
using namespace ::asf::core;

class genericAsfDBusProxy;

class genericAsfDBusCallbackIF
{
public:
virtual ~genericAsfDBusCallbackIF( ){}

virtual void onSignalChangedError( const ::boost::shared_ptr < genericAsfDBusProxy >& proxy,
                                   uint16                                             funcId )                      = 0;

virtual void onSignalChangedSignal( const ::boost::shared_ptr < genericAsfDBusProxy >& proxy,
                                    uint16                                             funcId,
                                    ::asf::dbus::DBusMessage                         & message )                    = 0;

};

/**
  * genericAsfDBusProxy is the client side representation of the D-Bus
  * service interface 'org.genivi.audiomanager.CommandInterface' (specified
  * in file CommandInterfaceIntrospectionData.xml).
  *
  * structure describing sink class
  * Param 1: Type - u16int_t : Sink Class ID
  * Param 2: Type - string : Sink class Name
  * Param 3: Type - list of am_ClassProperty_s : list of class properties
  */
class genericAsfDBusProxy : public ::asf::dbus::DBusProxy
{
public:
/**
  * Create a new instance of genericAsfDBusProxy.
  */
static ::boost::shared_ptr < genericAsfDBusProxy > createProxy( const std::string              & portName,
                                                                ::asf::core::ServiceAvailableIF& serviceAvailable,
                                                                const std::string              & strInterface ){
   ::boost::shared_ptr < Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy( portName, serviceAvailable );

   if ( proxyReuse ){
      return( ::boost::static_pointer_cast < genericAsfDBusProxy >( proxyReuse ) ); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
   }
   LOG_INFO_STATIC( "createProxy, create new proxy" );
   ::boost::shared_ptr < genericAsfDBusProxy > proxyNew( new genericAsfDBusProxy( portName, serviceAvailable, strInterface ) );
   ::asf::dbus::DBusConnector::registerProxyDelegate( proxyNew->_dbusProxyDelegate, proxyNew );
   proxyNew->createHelperProxies( true );
   return( proxyNew );
}

/**
  * Create a new instance of genericAsfDBusProxy.
  *
  * Use this method if you have the annotation @WiredAtRuntime set in your
  * component manifest for this service.
  *
  * @deprecated use the createProxy() method with the parameter
  * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
  */
static ::boost::shared_ptr < genericAsfDBusProxy > createProxy( const std::string              & portName,
                                                                const std::string              & busName,
                                                                const std::string              & objectPath,
                                                                ::DBusBusType                    busType,
                                                                ::asf::core::ServiceAvailableIF& serviceAvailable ){
   ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;

   connectorOptions.setBusType( ::asf::dbus::DBusUtils::toOptions( busType ).getBusType( ) );
   return( createProxy( portName, busName, objectPath, connectorOptions, serviceAvailable ) );
}

/**
  * Create a new instance of genericAsfDBusProxy.
  *
  * Use this method if you have the annotation @WiredAtRuntime set in your
  * component manifest for this service.
  */
static ::boost::shared_ptr < genericAsfDBusProxy > createProxy( const std::string                                                 & portName,
                                                                const std::string                                                 & busName,
                                                                const std::string                                                 & objectPath,
                                                                const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
                                                                ::asf::core::ServiceAvailableIF                                   & serviceAvailable ){
   LOG_INFO_STATIC( "createProxy, create new proxy" );
   ::boost::shared_ptr < genericAsfDBusProxy > proxyNew( new genericAsfDBusProxy( portName, serviceAvailable ) );
   ::asf::dbus::DBusConnector::registerProxyDelegate( proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions );
   proxyNew->createHelperProxies( false );
   return( proxyNew );
}

virtual ~genericAsfDBusProxy ( );

// Signal 'VolumeChanged'
act_t sendSignalRegister( const std::string       & signalName,
                          uint16                    funcId,
                          genericAsfDBusCallbackIF& cb );

bool sendPropertyChangedDeregister( const std::string& signalName,
                                    act_t              act );

void sendPropertyChangedDeregisterAll( );

act_t sendPropertyRegister( const std::string       & propertyName,
                            uint16                    funcId,
                            genericAsfDBusCallbackIF& cb );

act_t sendPropertyGet( const std::string       & propertyName,
                       uint16                    funcId,
                       genericAsfDBusCallbackIF& cb );

/**
  * Release all property and signal notifications.
  */
void sendDeregisterAll( );

private:
genericAsfDBusProxy ( const std::string              & portName,
                      ::asf::core::ServiceAvailableIF& serviceAvailable,
                      const std::string              & strInterface = "" );

act_t addMethodCallback( uint16 methodId,
                         uint32 serial,
                         void  *cb );

act_t addSignalCallback( uint16             signalId,
                         const std::string& signal,
                         void              *cb );


static ::asf::core::Logger _logger;

friend class genericAsfDBusProxyCallback;
};

