/* ***************************************************************************************
* FILE:          Project.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Project.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef PROJECT_H
#define PROJECT_H

#include "AppBase/app_base_defines.h"
#include "ProjectBaseTypes.h"

namespace hmi {
namespace apps {
// AppHmi_Master is predefined in the framework, see app_base_defines.h

namespace reference {
static const char* appHmi_Reception      = "AppHmi_Reception";
static const char* appHmi_Tuner    		 = "AppHmi_Tuner";
static const char* appHmi_Navigation     = "AppHmi_Navigation";
static const char* appHmi_Media          = "AppHmi_Media";
static const char* appHmi_Phone 		 = "AppHmi_Phone";
static const char* appHmi_SPI 		 	 = "AppHmi_SPI";
static const char* appHmi_Sds 		     = "AppHmi_Sds";
static const char* appHmi_System 		 = "AppHmi_System";
static const char* appHmi_Testmode 		 = "AppHmi_Testmode";
static const char* appHmi_Camera 		 = "AppHmi_Camera";
static const char* appHmi_Sxm	 		 = "AppHmi_Sxm";
} // reference
} // apps

namespace main_display_config {
static const int id = 1;
}


#ifdef VARIANT_S_FTR_ENABLE_SECOND_DISPLAY
namespace second_display_config {
static const int id = 1;
}


#endif

// identifier of shared memory used for direct texture exchange
#define SYNC_BLOCK_ID 765
}


#endif // PROJECT_H
