/**************************************************************************************
* @file         : PopupTimer.h
* @author       : ECV2-Binu John
* @addtogroup   : common
* @brief        :
* @copyright    : (C) 2016 Robert Bosch GmbH
*                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef POPUPTIMER_H
#define POPUPTIMER_H

#include "ProjectBaseMsgs.h"
#include <map>

namespace PopupTimerHandler {
class PopupTimer
{
   public:
      PopupTimer();
      virtual ~PopupTimer();

      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(StartPopupTimerReqMsg)
      ON_COURIER_MESSAGE(StopPopupTimerReqMsg)
      ON_COURIER_MESSAGE(RestartPopupTimerReqMsg)
      ON_COURIER_MESSAGE(TimerExpiredMsg)
      COURIER_MSG_MAP_END()

   protected:
      bool onCourierMessage(const StartPopupTimerReqMsg& oMsg);
      bool onCourierMessage(const StopPopupTimerReqMsg& oMsg);
      bool onCourierMessage(const RestartPopupTimerReqMsg& oMsg);
      //message from timer utility
      bool onCourierMessage(const TimerExpiredMsg& oMsg);
      void deletepopupTimer(::Util::Timer* popupTimer);
      uint32_t getViewName(::Util::Timer* popupTimerval);

   private:
      ::std::map<uint32_t, ::Util::Timer*> _popupTimerMap;
};


}

#endif
