/**
 * @file         : LanguageHandler.h
 * @author       :
 * @addtogroup   : AppHmi_App_PRJ_Common
 * @brief        : LanguageHandler is to handle the language / culture update implementation
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef LANGUAGE_HANDLER_H
#define LANGUAGE_HANDLER_H


#include "LanguageDpHandler.hpp"
#include "LanguageHandlerInterface.h"


/**
 * Classes Forward declaration
 */

namespace Courier {


class Message;
} // namespace Courier


/**
 * Classes declaration
 */

namespace languageHandler {


class LanguageHandler : public ILanguageStatusPropertyUpdateCB
{
   public:
      /**
       *  Member Function Declaration
       */
      virtual ~LanguageHandler();
      bool OnMessage(const ::Courier::Message& Msg);
      void onLanguageStatusUpdate(const uint32 languageId);

      inline static void deleteInstance()
      {
         if (NULL != _languageHandler)
         {
            delete _languageHandler;
            _languageHandler = NULL;
         }
      }

      inline static LanguageHandler* getInstance()
      {
         createInstance();
         return _languageHandler;
      }

      inline IServiceClient* getServiceClient() const
      {
         return _serviceClient;
      }

      inline const ILanguageDpHandler* getLanguageDpHandler() const
      {
         return _languageDpHandler;
      }

      inline const ILanguageISOCodeHandler* getLanguageISOCodeHandler() const
      {
         return _languageISOCodeHandler;
      }

      template<typename dpType>
      inline void initLanguageDpHandler()
      {
         if (NULL == _languageDpHandler)
         {
            _languageDpHandler = new LanguageDpHandler<dpType>();
            if (NULL != _languageDpHandler)
            {
               _languageDpHandler->setLanguageISOCodeHandler((*_languageISOCodeHandler));
               _languageDpHandler->init();
            }
         }
      }

      template<typename clientType>
      inline void initSeviceClient(IServiceClientConfigurator& imp)
      {
         if (NULL == _serviceClient)
         {
            clientType* temp = new clientType();
            if (NULL != temp)
            {
               _serviceClient = temp;
               temp->registerLanguageStatusPropertyUpdate((*this));
               temp->setConfigurator(imp);
               temp->init();
            }
         }
      }

   private:
      /**
       *  Member Function Declaration
       */
      LanguageHandler();
      LanguageHandler(const LanguageHandler& obj);
      LanguageHandler& operator = (const LanguageHandler& obj);
      void clear();
      void initLanguageISOCodeHandler();
      void performStartupLanguageUpdate();
      void sendLocalizationRequest(const uint32 languageId);

      inline static void createInstance()
      {
         if (NULL == _languageHandler)
         {
            _languageHandler = new LanguageHandler();
         }
      }
      /**
       *  Member Variable Declaration
       */
      bool _guiInitialized;
      IServiceClient* _serviceClient;
      ILanguageDpHandler* _languageDpHandler;
      ILanguageISOCodeHandler* _languageISOCodeHandler;
      static LanguageHandler* _languageHandler;
};


}// namespace languageHandler


#endif /* LANGUAGE_HANDLER_H */
