/**
 * @file         : HmiInfoServiceClient.h
 * @author       :
 * @addtogroup   : AppHmi_App_PRJ_Common
 * @brief        : HmiInfoServiceClient is to handle the HmiInfo service
 *                 client implementation
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef HMI_INFO_SERVICE_CLIENT_H
#define HMI_INFO_SERVICE_CLIENT_H


#include "LanguageHandlerInterface.h"
#include <AppBase/ServiceAvailableIF.h>
#include <bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceProxy.h>


/**
 *  Defines Declaration
 */

#define NS_HMI_INFO ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService


/**
 * Classes declaration
 */

namespace languageHandler {


class HmiInfoServiceClient : public IHmiInfoServiceClient
   , public ::hmibase::ServiceAvailableIF
   , public NS_HMI_INFO::LanguageStatusInfoCallbackIF
{
   public:
      /**
       *  Member Function Declaration
       */
      HmiInfoServiceClient();
      virtual ~HmiInfoServiceClient();
      bool fetchLanguageStatusInfo(uint32& languageId) const;
      void registerLanguageStatusPropertyUpdate(ILanguageStatusPropertyUpdateCB& imp);
      void deregisterLanguageStatusPropertyUpdate(ILanguageStatusPropertyUpdateCB& imp);
      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void onLanguageStatusInfoError(const ::boost::shared_ptr< NS_HMI_INFO::HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< NS_HMI_INFO::LanguageStatusInfoError >& error);
      void onLanguageStatusInfoUpdate(const ::boost::shared_ptr< NS_HMI_INFO::HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< NS_HMI_INFO::LanguageStatusInfoUpdate >& update);

      inline void init()
      {
         initHmiInfoServiceProxy();
      }

      inline void setConfigurator(IServiceClientConfigurator& imp)
      {
         _configurator = dynamic_cast< IHmiInfoServiceClientConfigurator* >(&imp);
      }

   private:
      /**
       *  Member Function Declaration
       */
      HmiInfoServiceClient(const HmiInfoServiceClient& obj);
      HmiInfoServiceClient& operator = (const HmiInfoServiceClient& obj);
      void clear();
      void initHmiInfoServiceProxy();

      inline bool isMyHmiInfoServiceProxy(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy) const
      {
         bool isValid = ((NULL != _hmiInfoProxy.get()) && (_hmiInfoProxy == proxy)) ? true : false;
         return isValid;
      }
      /**
       *  Member Variable Declaration
       */
      act_t _languageStatusInfoGet_RegId;
      act_t _languageStatusInfoUpdate_RegId;
      IHmiInfoServiceClientConfigurator* _configurator;
      ::boost::shared_ptr< NS_HMI_INFO::HmiInfoServiceProxy > _hmiInfoProxy;
      ::std::vector< ILanguageStatusPropertyUpdateCB* > _languageStatusPropertyUpdateCBInfo;
};


}// namespace languageHandler


#undef NS_HMI_INFO


#endif /* HMI_INFO_SERVICE_CLIENT_H */
