/**
 * @file         : LanguageHandlerAdapter.cpp
 * @author       :
 * @addtogroup   : AppHmi_App_PRJ_Common
 * @brief        : LanguageHandlerAdapter is to handle the adapter implementation of LanguageHandler
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#include "LanguageHandlerAdapter.h"
#include "unistd.h"
#include "CommonTrace.h"
#include "hmi_trace_if.h"
#include <Trace/TraceUtils.h>
#include <Core/LanguageHandler.h>
#include <asf/core/Application.h>
#include <Core/VehicleServiceClient.h>
#include <Core/HmiInfoServiceClient.h>


using namespace ::asf::core;
using namespace ::hmibase::trace;


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_COMMON
#include "trcGenProj/Header/LanguageHandlerAdapter.cpp.trc.h"
#endif /* VARIANT_S_FTR_ENABLE_TRC_GEN */


namespace languageHandler {


LanguageHandlerAdapter::LanguageHandlerAdapter()
{
   ETG_TRACE_USR1(("LanguageHandlerAdapter: INFO: APP: %25s : PID: %d : CTOR",  getAppName().c_str(), getpid()));
   initLanguageHandler();
}


LanguageHandlerAdapter::LanguageHandlerAdapter(const bool extended)
{
   ETG_TRACE_USR1(("LanguageHandlerAdapter: INFO: APP: %25s : PID: %d : CTOR",  getAppName().c_str(), getpid()));
   if (!extended)
   {
      initLanguageHandler();
   }
   else
   {
      /* INFO: Respective child has to invoke FN: initLanguageHandler() */
   }
}


LanguageHandlerAdapter::~LanguageHandlerAdapter()
{
   ETG_TRACE_USR1(("LanguageHandlerAdapter: INFO: APP: %25s : PID: %d : DTOR",  getAppName().c_str(), getpid()));
   LanguageHandler::deleteInstance();
}


void LanguageHandlerAdapter::initLanguageHandler()
{
   (void)LanguageHandler::getInstance();
   initServiceClient();
   initLanguageDpHandler();
}


void LanguageHandlerAdapter::initServiceClient()
{
   if (NULL == Application::getApplication())
   {
      return;
   }
   if (NULL == LanguageHandler::getInstance())
   {
      return;
   }
   if (strcmp(Application::getApplication()->getName().c_str(), "AppHmi_Master") == 0)
   {
      LanguageHandler::getInstance()->initSeviceClient<VehicleServiceClient>((*this));
   }
   else
   {
      LanguageHandler::getInstance()->initSeviceClient<HmiInfoServiceClient>((*this));
   }
}


bool LanguageHandlerAdapter::OnMessage(const ::Courier::Message& Msg)
{
   bool isConsumed = false;
   if (NULL != LanguageHandler::getInstance())
   {
      isConsumed = LanguageHandler::getInstance()->OnMessage(Msg);
   }
   return isConsumed;
}


void LanguageHandlerAdapter::configureHmiInfoServicePortName(::std::string& name, bool& isWiredRunTime)
{
   isWiredRunTime = false;
   name           = "hmiinfoservicePort";
}


void LanguageHandlerAdapter::configureVehicleServicePortName(::std::string& name, bool& isWiredRunTime)
{
   isWiredRunTime = false;
   name           = "vehicleMainFiPort";
}


} // namespace languageHandler
