/* ***************************************************************************************
* FILE:          FocusOnTouchHandler.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FocusOnTouchHandler.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"
#include "ProjectBaseMsgs.h"

#include "FocusOnTouchHandler.h"
#include <Focus/Default/FDefaultAvgBuilder.h>
#include <Widgets/2D/Button/ButtonWidget2D.h>

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/FocusOnTouchHandler.cpp.trc.h"
#endif

COURIER_LOG_SET_REALM(Candera::Diagnostics::LogRealm::User);

template <typename TWidget>
class WidgetIdFinderCallback : public WidgetCheckCallback
{
   public:
      WidgetIdFinderCallback(const Courier::Identifier& id) : _widgetId(id), _widget(NULL) { }

      virtual ~WidgetIdFinderCallback()
      {
         _widget = NULL;
      }

      virtual bool CheckWidget(Candera::Widget2D* widget)
      {
         TWidget* baseWidget = Candera::Dynamic_Cast<TWidget*>(widget);
         if ((baseWidget != NULL) && (_widgetId == Courier::Identifier(baseWidget->GetLegacyName())))
         {
            _widget = baseWidget;
            return true;
         }
         return false;
      }

      TWidget* GetWidget() const
      {
         return _widget;
      }

   private:
      Courier::Identifier _widgetId;
      TWidget* _widget;
};


bool FocusOnTouchHandler::onMessage(const Focus::FMessage& msg)
{
   bool consumed = false;

   if (msg.GetId() == ButtonReactionMsg::ID)
   {
      const ButtonReactionMsg* buttonMsg = Courier::message_cast<const ButtonReactionMsg*>(&msg);
      if ((buttonMsg != NULL) && (buttonMsg->GetEnReaction() == enPress) && (_manager.getOutputMsgHandler() != NULL))
      {
         //hide the focus
         _manager.getOutputMsgHandler()->postMessage(COURIER_NEW(FocusControlReqMsg)(hmibase::enFocusHide, hmibase::enFocusTimerNoAction, Courier::ViewId(), ""));

         //change the focus to the pressed button
         //for this to worked correctly it is necessary that no button press is consumed in the state machine
         WidgetIdFinderCallback<ButtonWidget2D> callback(buttonMsg->GetSender());
         WidgetCheckReqMsg callbackMsg(&callback);
         _manager.getOutputMsgHandler()->dispatchToView(buttonMsg->GetView(), callbackMsg);
         if ((callback.GetWidget() != NULL) && (callback.GetWidget()->GetFocusableStatus()))
         {
            _manager.getOutputMsgHandler()->postMessage(COURIER_NEW(FocusControlReqMsg)(hmibase::enFocusSet, hmibase::enFocusTimerNoAction,
                  buttonMsg->GetView(), callback.GetWidget()->GetLegacyName()));
         }
      }
   }

   return consumed;
}
