/* ***************************************************************************************
* FILE:          DefaultListRotaryController.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DefaultListRotaryController.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __DEFAULT_LIST_ROTARY_CONTROLLER_H__
#define __DEFAULT_LIST_ROTARY_CONTROLLER_H__

#include <Focus/FCommon.h>
#include <Focus/FController.h>

namespace Focus {
class FSession;
class FWidgetConfig;
class FGroup;
}


class ListFocusChangeReqMsg;
class ListFocusResetReqMsg;
class EncoderStatusChangedUpdMsg;

class DefaultListRotaryController : public Focus::FController
{
   public:
      DefaultListRotaryController(bool invertedRotary = false, bool pagewiseScrolling = false);

      virtual bool configureWidget(Focus::FSession&, Focus::FWidgetConfig& handle, Focus::FFrameworkWidget& widget);
      virtual bool onMessage(Focus::FSession& session, Focus::FGroup& group, const Focus::FMessage& msg);

   private:
      DefaultListRotaryController(const DefaultListRotaryController&);
      DefaultListRotaryController& operator=(const DefaultListRotaryController&);

      bool onFocusChangeReqMessage(Focus::FSession& session, Focus::FGroup& group, const ListFocusChangeReqMsg& msg);
      bool onFocusResetReqMessage(Focus::FSession& session, Focus::FGroup& group, const ListFocusResetReqMsg& msg);
      bool onRotaryMessage(Focus::FSession& session, Focus::FGroup& group, const EncoderStatusChangedUpdMsg& msg);

      bool handleIncompleteFocusMove(Focus::FSession& session, Focus::FGroup& group, int correction);
      static void onListWidgetContentUpdated(Candera::UInt32 listId, bool success);

      bool _pagewiseScrolling;
      bool _invertedRotary;
      static Courier::IViewHandler* _viewHandler;
};


#endif
