/* ***************************************************************************************
* FILE:          DefaultFocusReqHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DefaultFocusReqHandler.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __DEFAULT_FOCUS_REQ_HANDLER_H__
#define __DEFAULT_FOCUS_REQ_HANDLER_H__


#include <Focus/FManager.h>
#include <Focus/FManagerConfig.h>

///////////////////////////////////////////////////////////////////////////////
class DefaultFocusReqHandler : public Focus::FController
{
   public:
      DefaultFocusReqHandler(Focus::FManager& manager) : _manager(manager) {}

      virtual bool onMessage(Focus::FSession& session, Focus::FGroup& group, const Focus::FMessage& msg);

   private:
      DefaultFocusReqHandler(const DefaultFocusReqHandler&);
      DefaultFocusReqHandler& operator=(const DefaultFocusReqHandler&);

      Focus::FManager& _manager;
};


#endif
