/* ***************************************************************************************
* FILE:          DefaultFocusInput.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DefaultFocusInput.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "ProjectBaseMsgs.h"
#include "DefaultFocusInput.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/DefaultFocusInput.cpp.trc.h"
#endif

COURIER_LOG_SET_REALM(Candera::Diagnostics::LogRealm::User);


///////////////////////////////////////////////////////////////////////////////
bool DefaultInputMsgChecker::isFocusInputMessage(const Focus::FMessage& msg) const
{
   bool result = false;
   switch (msg.GetId())
   {
      case HKStatusChangedUpdMsg::ID:
      {
         const HKStatusChangedUpdMsg* hkMsg = Courier::message_cast<const HKStatusChangedUpdMsg*>(&msg);
         if (hkMsg != NULL)
         {
            result = isFocusInputHKMessage(*hkMsg);
         }
         break;
      }

      case EnterKeyStatusChangedUpdMsg::ID:
      {
         const EnterKeyStatusChangedUpdMsg* enterKeyMsg = Courier::message_cast<const EnterKeyStatusChangedUpdMsg*>(&msg);
         if (enterKeyMsg != NULL)
         {
            result = isFocusInputEnterKeyMessage(*enterKeyMsg);
         }
         break;
      }

      case EncoderStatusChangedUpdMsg::ID:
      {
         const EncoderStatusChangedUpdMsg* encoderMsg = Courier::message_cast<const EncoderStatusChangedUpdMsg*>(&msg);
         if (encoderMsg != NULL)
         {
            result = isFocusInputEncoderMessage(*encoderMsg);
         }
         break;
      }

      case JoystickStatusChangedUpdMsg::ID:
      {
         const JoystickStatusChangedUpdMsg* joystickMsg = Courier::message_cast<const JoystickStatusChangedUpdMsg*>(&msg);
         if (joystickMsg != NULL)
         {
            result = isFocusInputJoystickMessage(*joystickMsg);
         }
         break;
      }

      case FocusReqMsg::ID:
      case FocusControlReqMsg::ID:
      case ListFocusChangeReqMsg::ID:
      case ListFocusResetReqMsg::ID:
      {
         result = true;
         break;
      }

      default:
         break;
   }

   return result;
}


///////////////////////////////////////////////////////////////////////////////
bool DefaultInputMsgChecker::isFocusInputHKMessage(const HKStatusChangedUpdMsg& msg) const
{
   switch (msg.GetHKCode())
   {
      //todo: add here more Enter keys, also check the existing ones
      case HARDKEYCODE_SWC_OK:
      case HARDKEYCODE_SWC_ROTARY_ENCODER_BUTTON:
      case HARDKEYCODE_HK_SELECT:
      case HARDKEYCODE_HK_SRC_COCKPIT:
      {
         return true;
      }
      break;                                                                              //lint !e527

      default:
         break;
   }

   return false;
}


///////////////////////////////////////////////////////////////////////////////
bool DefaultInputMsgChecker::isFocusInputEnterKeyMessage(const EnterKeyStatusChangedUpdMsg&) const
{
   return true;
}


///////////////////////////////////////////////////////////////////////////////
bool DefaultInputMsgChecker::isFocusInputEncoderMessage(const EncoderStatusChangedUpdMsg& msg) const
{
   return msg.GetEncCode() == ENCCODE_RIGHT_ENCODER;                                      //lint !e641
}


///////////////////////////////////////////////////////////////////////////////
bool DefaultInputMsgChecker::isFocusInputJoystickMessage(const JoystickStatusChangedUpdMsg&) const
{
   return true;
}


///////////////////////////////////////////////////////////////////////////////
bool DefaultHKtoEnterKeyConverter::onMessage(const Focus::FMessage& msg)
{
   if (msg.GetId() == HKStatusChangedUpdMsg::ID)
   {
      const HKStatusChangedUpdMsg* hkMsg = Courier::message_cast<const HKStatusChangedUpdMsg*>(&msg);
      if ((hkMsg != NULL) && (_manager.getOutputMsgHandler() != NULL))
      {
         switch (hkMsg->GetHKCode())
         {
            //todo: add here more Enter keys, also check the existing ones
            case HARDKEYCODE_SWC_OK:
            case HARDKEYCODE_SWC_ROTARY_ENCODER_BUTTON:
            case HARDKEYCODE_HK_SELECT:
            {
               _manager.getOutputMsgHandler()->postMessage(COURIER_NEW(EnterKeyStatusChangedUpdMsg)(hkMsg->GetHKState(), hkMsg->GetHKCode()));
               return true;
            }
            break;                                                                        //lint !e527
            case HARDKEYCODE_HK_SRC_COCKPIT:
            {
               if (hkMsg->GetHKState() == hmibase::HARDKEYSTATE_UP)
               {
                  //_manager.getOutputMsgHandler()->postMessage(COURIER_NEW(EncoderStatusChangedUpdMsg)(ENCCODE_RIGHT_ENCODER, /*step*/1, 0));

                  ETG_TRACE_USR1_THR(("DefaultHKtoEnterKeyConverter::FMessage result"));

                  ETG_TRACE_FATAL(("DefaultHKtoEnterKeyConverter::FMessage result"));
                  return true;
               }
            }
            break;
            default:
               break;
         }
      }
   }

   return false;
}
