/* ***************************************************************************************
* FILE:          DefaultFocusConsistencyChecker.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DefaultFocusConsistencyChecker.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __DEFAULT_FOCUS_CONSISTENCY_CHECKER_H__
#define __DEFAULT_FOCUS_CONSISTENCY_CHECKER_H__

#include <Focus/FManager.h>
#include <Focus/FManagerConfig.h>

///////////////////////////////////////////////////////////////////////////////
class DefaultFocusConsistencyChecker : public Focus::FConsistencyChecker, public Focus::FMsgReceiver
{
   public:
      DefaultFocusConsistencyChecker(Focus::FManager& manager);
      virtual ~DefaultFocusConsistencyChecker();

      virtual bool onMessage(const Focus::FMessage& msg);
      virtual bool checkFocus();

      void restartTimer();
      void stopTimer();

   private:
      DefaultFocusConsistencyChecker(const DefaultFocusConsistencyChecker&);
      DefaultFocusConsistencyChecker& operator=(const DefaultFocusConsistencyChecker&);

      Focus::FManager& _manager;
      Util::Timer* _timer;
};


#endif
