/* ***************************************************************************************
* FILE:          DefaultFocus.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DefaultFocus.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __DEFAULT_FOCUS_H__
#define __DEFAULT_FOCUS_H__

#include <Focus/Default/FDefaultManagerConfig.h>

class AppViewHandler;
class DefaultActivityTimerListener;
class DefaultIpcAdapter;
class DefaultHKtoEnterKeyConverter;
class DefaultFocusConsistencyChecker;
class FocusOnTouchHandler;

class DefaultFocusManagerConfigurator : public Focus::FDefaultManagerConfigurator
{
      typedef Focus::FDefaultManagerConfigurator Base;
   public:
      DefaultFocusManagerConfigurator(Focus::FManager& manager, AppViewHandler& viewHandler, const Focus::FAppId& currentAppId);
      virtual ~DefaultFocusManagerConfigurator();

      virtual bool initialize();
      virtual bool finalize();

   protected:
      virtual bool initializeAnimationManager();

      virtual bool initializeTimers();
      virtual bool finalizeTimers();

      virtual bool initializeConsistencyChecker();
      virtual bool initializeVisibilityManager();

      virtual bool initializeControllers();
      virtual bool finalizeControllers();

      virtual bool initializeInputMsgChecker();
      virtual bool finalizeInputMsgChecker();

      virtual bool initializeIpcManager();
      virtual bool finalizeIpcManager();

   private:
      DefaultFocusManagerConfigurator(const DefaultFocusManagerConfigurator&);
      DefaultFocusManagerConfigurator& operator=(const DefaultFocusManagerConfigurator&);

      DefaultActivityTimerListener* _activityTimerListener;
      DefaultIpcAdapter* _ipcAdapter;
      DefaultHKtoEnterKeyConverter* _hkConverter;
      FocusOnTouchHandler* _onTouchHandler;
};


class DefaultFocus
{
   public:
      static Focus::FDefaultManagerConfigurator* createConfigurator(AppViewHandler& viewHandler, const Focus::FAppId& currentAppId = Focus::Constants::InvalidAppId);
};


#endif
