/**************************************************************************************
* @file         : <DefSetServiceBase.h>
* @author       : RBEI/COB/ECV3
* @addtogroup   : common
* @brief        :
* @copyright    : (C) 2016 Robert Bosch GmbH
*                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/


#ifndef DEFSETSERVICEBASE_HEADER
#define DEFSETSERVICEBASE_HEADER

#include "asf/core/BaseComponent.h"
#include "asf/core/ComponentFactory.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1Stub.h"

using namespace ::asf::core;
using namespace ::org::bosch::cm::diagnosis::dbus::Diagnosis1::SystemSettings1;


namespace App {
namespace Core {

struct PrepareResDiagMsgData
{
   std::string sysSetType;
};


struct ExecuteResDiagMsgData
{
   std::string sysSetType;
};


struct FinalizeResDiagMsgData
{
   std::string sysSetType;
};


class iDefSetServiceBase
{
   private:

   public:
      virtual ~iDefSetServiceBase() {};
      virtual void reqPrepareResponse(const PrepareResDiagMsgData&) = 0;
      virtual void reqExecuteResponse(const ExecuteResDiagMsgData&) = 0;
      virtual void reqFinalizeResponse(const FinalizeResDiagMsgData&) = 0;
};


class DefSetServiceBase:
   public SystemSettings1Stub
{
   public:

      DefSetServiceBase(const std::string& portName);
      virtual ~DefSetServiceBase();

   public:
      void vRegisterforUpdate(iDefSetServiceBase* client);
      void vUnRegisterforUpdate(iDefSetServiceBase* client);

   public:
      void sendPrepareResponse(const int& response, iDefSetServiceBase* client);
      void sendExecuteResponse(const int& response, iDefSetServiceBase* client);
      void sendFinalizeResponse(const int& response, iDefSetServiceBase* client);

   public:
      virtual void onPrepareSystemSettingRequest(const ::boost::shared_ptr< PrepareSystemSettingRequest >& request);
      virtual void onExecuteSystemSettingRequest(const ::boost::shared_ptr< ExecuteSystemSettingRequest >& request);
      virtual void onFinalizeSystemSettingRequest(const ::boost::shared_ptr< FinalizeSystemSettingRequest >& request);

   public:
      static DefSetServiceBase* GetInstance();
      static void s_Intialize(const std::string& portName);
      static void s_Destrory();

   private:
      static DefSetServiceBase* _defSetServiceBase;

      std::vector<iDefSetServiceBase*> _defSetServiceBaseCallback;

      void sendPrepareRequest(const PrepareResDiagMsgData&);
      void sendExecuteRequest(const ExecuteResDiagMsgData&);
      void sendFinalizeRequest(const FinalizeResDiagMsgData&);

      void setPrepReqRespFlagReqPosition(unsigned int reqPosition, bool value);
      void setExecReqRespFlagReqPosition(unsigned int reqPosition, bool value);
      void setFinalReqRespFlagReqPosition(unsigned int reqPosition, bool value);

      int prepareResponseReceived;
      int executeResponseReceived;
      int finalizeResponseReceived;

      PrepareSystemSettingRequest& rObjPrepareSystemSettingRequest;
      ExecuteSystemSettingRequest& rObjExecuteSystemSettingRequest;
      FinalizeSystemSettingRequest& rObjFinalizeSystemSettingRequest;

      std::vector<bool> flagPrepReqRespRepository;
      std::vector<bool> flagExecReqRespRepository;
      std::vector<bool> flagFinalReqRespRepository;
};


}
}


#endif //DEFSETSERVICEBASE_HEADER
