/**
 * @file        :  CommonClockUtility.h
 * @addtogroup  :  AppHmi_App_Common
 * @brief       :  Contains utility methods used for date and time conversion
 * @copyright   :  (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */
#ifndef COMMON_CLOCK_UTILITY_H
#define COMMON_CLOCK_UTILITY_H

#include <string>

/**
*  DateFormatTypeIndex - To handle Date Format
*  Enum values are based on type VDCLK_TEN_DateFormat
*  path: di_middleware_server\components\vd_clock\fi\cca\clock_fi\clock_main_fi\clock_main_fi.pdf
*/
enum DateFormatTypeIndex
{
   DD_MM_YYYY = 1,
   MM_DD_YYYY,
   YYYY_MM_DD,
   DD_MM_YYYY_SLASH,
   MM_DD_YYYY_SLASH,
   DD_MM_YYYY_DOT,
   YYYY_MM_DD_JPN,
   YYYY_MM_DD_KOR
};


/**
 *  TimeFormat - To handle Time Format
 *  Enum values are based on type VDCLK_TEN_TimeFormat
 *  path: di_middleware_server\components\vd_clock\fi\cca\clock_fi\clock_main_fi\clock_main_fi.pdf
 */
enum Timeformat
{
   TWELEVE_HR = 1u,
   TWENTYFOUR_HR = 2u
};


/**
 *  MeridiemValue - To handle Meridiem values
 */
enum MeridiemValue
{
   ANTE_MERIDIEM_MODE,
   POST_MERIDIEM_MODE,
   TIME_24H_MODE,
   INVALID_MERIDIEM_MODE
};


/**
 *  DatePropertyInfo - To handle Date Info
 */
struct DatePropertyInfo
{
   uint8 day;
   uint8 month;
   uint16 year;
};


class CommonClockUtility
{
   public:
      virtual~CommonClockUtility();
      CommonClockUtility();
      std::string performDateFormatConversionWithOutYear(uint8 dateFormatIndex, const DatePropertyInfo&) const;
      std::string performDateFormatConversion(uint8 dateFormatIndex, const DatePropertyInfo&) const;
      std::string performTimeFormatAndMeridiemCalc(const uint8 hour, const uint8 min, const Timeformat _timeformat) const;
      MeridiemValue performMeridiemModeCalc(const Timeformat _timeformat, const uint8 hour) const;
      bool performTwentyFourHourValidCheck(const uint8 currentHour) const;
      bool performTimeFormatValidCheck(const uint8 currentTimeFormat) const;
      uint8 performEqualTweleveHourCalc(const uint8 hour, const MeridiemValue nMeridiemValue) const;
      std::string getdatetext(uint8 dateFormatIndex , std::string dayText, std::string monthtext, std::string yearText) const;
};


#endif
