/**************************************************************************************
* @file         : TunerDataPoolConfig.h
* @author       : ECV2-AGN7KOR
* @addtogroup   : AppHmi_Tuner
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef TUNER_DATAPOOLCONFIG_H_
#define TUNER_DATAPOOLCONFIG_H_

#include "asf/core/Types.h"
#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_hmi_02_if.h"
#endif
// Forward Declarations
//class dp_tclAppHmi_TunerLanguageDP;

/**
 * class TunerDataPoolConfig
 * This class hold implementation related to Datapool elements. It provides interfaces to read/write DP elements
 */
class TunerDataPoolConfig
{
   public:
      /**
       * Destructor of class DataPoolConfig
       * @return None
       */

      virtual ~TunerDataPoolConfig();
      /**
      * Singleton Class. Method to retrieve the instance of the class
      * @return Returns instance of the class
      */
      static TunerDataPoolConfig* getInstance();

      /**
        * Setter function to write the Spi Auto Lunch Mode status Dp element
        * @param[in] LanguageIndexTuner: Language
        * @return None
        */
      void setLanguage(const uint8 LanguageIndexTuner);

      /**
       * Getter function to read the LanguageIndexTuner status Dp element
       * @return LanguageIndexTuner
       */
      uint8 getLanguage();
      uint8 readRegionType();
      uint8 readDABMountedValue();
      uint8 readDABMountedSystemValue();
      uint8 readAMActivatedValue();
      void readKdsForRegion();
      void readDABMounted();
      void readDABMountedSystem();
      void readAMActivation();
      bool getRadioTextStatus();
      void setRadioTextStatus(bool radioTextStatus);

      void vSetDabDynamicContentStatus(bool bOptStatus);
      void vSetDabFmFollowingStatus(bool bOptStatus);
      void vSetDabDabFollowingStatus(bool bOptStatus);

      bool isNARVariant();

      uint8 readSXMMountedValue();
      void readSXMMounted();

      tU8 readTestmodeValue();
      void readTestmode();
   private:

      // Instance of the class
      static TunerDataPoolConfig* _DpTuner;

      TunerDataPoolConfig();
      TunerDataPoolConfig(const TunerDataPoolConfig&);
      TunerDataPoolConfig& operator=(const TunerDataPoolConfig&);
      //DP Elements
      dp_tclAppHmi_TunerLanguageDP _DpLanguage;
      /* Region type */
      uint8 _regionType;
      uint8 _DABMounted;
      uint8 _DABMountedSystem;
      uint8 _AMActivatedValue;
      uint8 _SXMMounted;
      uint8 _BlockTestMode;

      tU8*  _testModeValue;
#ifdef VARIANT_S_FTR_ENABLE_AIVI_SCOPE2
      dp_tclAppHmi_TunerDTVRemoteLocation _DpRemoteLocation;
#endif
};


#endif /* DATAPOOLCONFIG_H_ */
