/**************************************************************************************
* @file         : WeatherBand.h
* @author       : ECH2-Narahari/Suman
* @addtogroup   : Tuner HALL
* @brief        : Class contains necessary business logic required to handle AM FM Testmode data.
* @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef WeatherBandMain_H
#define WeatherBandMain_H

#include "MIDW_TUNER_FIProxy.h"
#include "MIDW_TUNERMASTER_FIProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "AppBase/StartupSync/StartupSync.h"
#include <AppHmi_TunerMessages.h>
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppHmi_TunerStateMachine.h"
#include "Tuner_Defines.h"
#include "midw_tuner_fi_types.h"
#include "midw_tunermaster_fi_types.h"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeProxy.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesProxy.h"

namespace App {
namespace Core {
//Forward Declarations
//@ded6kor: commented below for testing.


/* class WeatherBandMain
 * The properties and methods of MIDW_TUNER_FI and MIDW_TUNERMASTER_FI required for TestMode data are implemented by this class
 */
class WeatherBandMain :
   public StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,
   public ::MIDW_TUNER_FI::FID_TUN_S_DIRECT_FREQUENCYCallbackIF,
   public ::MIDW_TUNER_FI::FID_TUN_G_ATSTATIONINFOCallbackIF,
//public ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActivateSourceCallbackIF,
//public ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActiveSourceCallbackIF,
   public ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MuteStateCallbackIF
//public ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActiveSourceListCallbackIF


{
   public:
      static WeatherBandMain* poGetInstance()
      {
         if (NULL == _WeatherBandMainInst)
         {
            _WeatherBandMainInst = new WeatherBandMain();
         }

         return _WeatherBandMainInst;
      }

      virtual ~WeatherBandMain();

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      // ServiceAvailableIF implementation
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      virtual void onFID_TUN_S_DIRECT_FREQUENCYError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_DIRECT_FREQUENCYError >& /*error*/);
      virtual void onFID_TUN_S_DIRECT_FREQUENCYResult(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_S_DIRECT_FREQUENCYResult >& /*result*/);
      virtual void onFID_TUN_G_ATSTATIONINFOError(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_ATSTATIONINFOError >& /*error*/);
      virtual void onFID_TUN_G_ATSTATIONINFOStatus(const ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MIDW_TUNER_FI::FID_TUN_G_ATSTATIONINFOStatus >& status);
      //////////////////////////////////////////////
      //virtual void onActivateSourceError(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
      //	const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActivateSourceError >& /*error*/);
      //virtual void onActivateSourceResponse(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
      //	const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActivateSourceResponse >& /*response*/);

      //virtual void onActiveSourceError(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
      //	const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActiveSourceError >& /*error*/);

      //virtual void onActiveSourceUpdate(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
      //	const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActiveSourceUpdate >& update);

      //virtual void onActiveSourceListError(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
      //	const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActiveSourceListError >& /*error*/);

      //virtual void onActiveSourceListUpdate(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
      //	const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::ActiveSourceListUpdate >& update);

      /*Entertainment mute functionality */
      virtual void onMuteStateError(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertiesProxy >& /*proxy*/,
                                    const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MuteStateError >& /*error*/);
      virtual void onMuteStateUpdate(const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertiesProxy >& /*proxy*/,
                                     const ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::MuteStateUpdate >& update);
      //////////////////////////////////////////////
      bool onCourierMessage(const Tuner_WxBLMsg& corfoMsg);

      DataBindingItem<PresetInfoWBDataBindingSource> oPresetInfoWB;
      DataBindingItem<WBPresetInfoDataBindingSource> oWBPresetInfo;
      DataBindingItem<HomeScreenInfoDataBindingSource> oHomeScreenInfo;

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TUNER_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(Tuner_WxBLMsg)
      COURIER_DUMMY_CASE(0)
      COURIER_MSG_MAP_DELEGATE_DEF_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEF_END()
      COURIER_MSG_MAP_DELEGATE_END()

      uint32 getFrequencyFromTable(int index);

      std::string formatTestmodeFrequency(const uint32& frequency);

      bool update_WB_PresetFocused(uint16 PresetNumber);
      std::string getfreqvalue();
      std::string getPacvalue();
      uint32 m_WBFrequency;
      std::string m_wxFrequencyvalue;
      std::string m_wxPACvalue;
      static void TraceCmd_onPresetData();
      void presetData();

   private:
      /** Instance of MIDW_TUNER_FIProxy */
      ::boost::shared_ptr< ::MIDW_TUNER_FI::MIDW_TUNER_FIProxy > _tunerFiProxy;

      /** Instance of MIDW_TUNERMASTER_FIProxy */
      ::boost::shared_ptr< ::MIDW_TUNERMASTER_FI::MIDW_TUNERMASTER_FIProxy > _tunerMasterFiProxy;
      /** Instance of AUDIO_Proxy */
      //::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange::AudioSourceChangeProxy > _audioSrcChgProxy;
      /** Instance of SoundPropertiesProxy */
      ::boost::shared_ptr< ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties::SoundPropertiesProxy > _soundPropertiesProxy;
      /** Instance for the TTFIs Trace command. */
      static WeatherBandMain* _WeatherBandMainInst;
      WeatherBandMain();
      DECLARE_CLASS_LOGGER();
};


} // namespace Core
} // namespace App

#endif
