/**
 * @file <VehicleSrvClient.h>
 * @author <ECG> <INF4CV>
 * @copyright (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 * @addtogroup <AppHmi_Tuner>
 */

#ifndef LANGUAGE_CLIENT_H
#define LANGUAGE_CLIENT_H

#ifndef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
#define LANGNO  19
#endif

#ifdef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
#define LANGNO  22
#endif

#include "VEHICLE_MAIN_FIProxy.h"
#include "vehicle_main_fi_types.h"
//#include "datacollector_main_fiProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "Common/DataModel/ListRegistry.h"
//#include "App/Core/Tuner_Defines.h"
#include <bits/stdc++.h>
namespace App {
namespace Core {

class VehicleSrvClient : public ListImplementation,
   public StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,
   public ::VEHICLE_MAIN_FI::LanguageSyncSourceCallbackIF,
   public ::VEHICLE_MAIN_FI::SetLanguageCallbackIF,
   public ::VEHICLE_MAIN_FI::LanguageCallbackIF,
   public ::VEHICLE_MAIN_FI::TrackCommandCallbackIF,
   public ::VEHICLE_MAIN_FI::TunerCommandCallbackIF,
   public ::VEHICLE_MAIN_FI::TACommandCallbackIF,
   public ::VEHICLE_MAIN_FI::RDSCommandCallbackIF,
   public ::VEHICLE_MAIN_FI::DeviceStatusDABAvailStatusCallbackIF,
   public ::VEHICLE_MAIN_FI::MediaStatusDABFMStatusCallbackIF,
   public ::VEHICLE_MAIN_FI::MediaStatusRDSStatusCallbackIF,
   public ::VEHICLE_MAIN_FI::MediaStatusTAStatusCallbackIF,
   public ::VEHICLE_MAIN_FI::MediaStatusTPStatusCallbackIF,
   public ::VEHICLE_MAIN_FI::MediaStatusTunerBandStatusCallbackIF,
   public ::VEHICLE_MAIN_FI::MediaStatusTunerPresetStatusCallbackIF,
   public ::VEHICLE_MAIN_FI::DeviceStatusAMFMAvailCallbackIF,
   public ::VEHICLE_MAIN_FI::SourceCommandCallbackIF,
   public ::VEHICLE_MAIN_FI::CabinMediaTrackCommandCallbackIF,
   public ::VEHICLE_MAIN_FI::CabinMediaTunerCommandCallbackIF,
   public ::VEHICLE_MAIN_FI::SendMediaInfoCallbackIF,
   public ::VEHICLE_MAIN_FI::SendMainlineInfoCallbackIF,
   public ::VEHICLE_MAIN_FI::CabinMediaSourceCommandCallbackIF,
   public ::VEHICLE_MAIN_FI::CabinMediaStatusTunerBandCallbackIF


{
   public:
      static VehicleSrvClient* poGetInstance()
      {
         if (NULL == _VehicleSrvClient)
         {
            _VehicleSrvClient = new VehicleSrvClient();
         }

         return _VehicleSrvClient;
      }
      virtual ~VehicleSrvClient();
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                              const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                                const asf::core::ServiceStateChange& /*stateChange*/);
      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void onSetLanguageError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                              const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SetLanguageError >& error);
      void onSetLanguageResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                               const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SetLanguageResult >& result);
      void onLanguageSyncSourceError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, \
                                     const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageSyncSourceError >& /*error*/) {}
      void onLanguageSyncSourceStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, \
                                      const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageSyncSourceStatus >& /*status*/) {}
      void onLanguageStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                            const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageStatus >& status);
      void onLanguageError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, \
                           const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageError >& error);

      virtual void onTrackCommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::TrackCommandError >& error);
      virtual void onTrackCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::TrackCommandStatus >& status);

      virtual void onTunerCommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::TunerCommandError >& error);
      virtual void onTunerCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::TunerCommandStatus >& status);

      virtual void onTACommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::TACommandError >& error);
      virtual void onTACommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::TACommandStatus >& status);

      virtual void onRDSCommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::RDSCommandError >& error);
      virtual void onRDSCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::RDSCommandStatus >& status);

      virtual void onDeviceStatusDABAvailStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusDABAvailStatusError >& error);
      virtual void onDeviceStatusDABAvailStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusDABAvailStatusResult >& result);

      virtual void onMediaStatusDABFMStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusDABFMStatusError >& error);
      virtual void onMediaStatusDABFMStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusDABFMStatusResult >& result);

      virtual void onMediaStatusRDSStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusRDSStatusError >& error);
      virtual void onMediaStatusRDSStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusRDSStatusResult >& result);

      virtual void onMediaStatusTAStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusTAStatusError >& error);
      virtual void onMediaStatusTAStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusTAStatusResult >& result);

      virtual void onMediaStatusTPStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusTPStatusError >& error);
      virtual void onMediaStatusTPStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusTPStatusResult >& result);

      virtual void onMediaStatusTunerBandStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusTunerBandStatusError >& error);
      virtual void onMediaStatusTunerBandStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusTunerBandStatusResult >& result);

      virtual void onMediaStatusTunerPresetStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusTunerPresetStatusError >& error);
      virtual void onMediaStatusTunerPresetStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusTunerPresetStatusResult >& result);
      virtual void onDeviceStatusAMFMAvailError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusAMFMAvailError >& error);
      virtual void onDeviceStatusAMFMAvailResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusAMFMAvailResult >& result);

      void onSourceCommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SourceCommandError >& error);
      void onSourceCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SourceCommandStatus >& Status);

      virtual void onCabinMediaTrackCommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CabinMediaTrackCommandError >& error);
      virtual void onCabinMediaTrackCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CabinMediaTrackCommandStatus >& status);

      virtual void onCabinMediaTunerCommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CabinMediaTunerCommandError >& error);
      virtual void onCabinMediaTunerCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CabinMediaTunerCommandStatus >& status);

      virtual void onSendMediaInfoError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendMediaInfoError >& error);
      virtual void onSendMediaInfoResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy  >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendMediaInfoResult >& result);

      virtual void onSendMainlineInfoError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendMainlineInfoError >& error);
      virtual void onSendMainlineInfoResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy  >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendMainlineInfoResult >& result);

      virtual void onCabinMediaSourceCommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CabinMediaSourceCommandError >& error);
      virtual void onCabinMediaSourceCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CabinMediaSourceCommandStatus >& status);

      virtual void onCabinMediaStatusTunerBandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CabinMediaStatusTunerBandError >& error);
      virtual void onCabinMediaStatusTunerBandResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CabinMediaStatusTunerBandResult >& result);

      void vUpdateTunerLongDataToCAN(std::vector<uint8> tunerCANLongData);
      void pushTunerCANLongData(uint8 tunerType, std::string tunerData);

      std::vector<uint8> _tunerCANLongDataInfo;

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_TUNER_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_DUMMY_CASE(0)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_END()
      std::string getLanguageId(int index);
      void readLanguageOnStartUp();
      void updateTAStatus(int taStatus);
      void updateRDSStatus(int rdsStatus);
      void updateTPStatus(int tpStatus);
      void updateDABFMStatus(int dabfmStatus);
      void updateDABAvailStatus(int dabStatus);
      void updateTunerPresetStatus(int presetId);
      void updateTunerBandStatus(int bandId);
      void updateCabinTunerBandStatus(int bandId);
      void updateAMFMAvailStatus(int amfmStatus);

   private:
      VehicleSrvClient();
      static VehicleSrvClient* _VehicleSrvClient;
      ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy> _vehicleProxy;
};


}
}


#endif
