/**************************************************************************************
* @file         : <VehicleSrvClient.cpp>
* @author       : <ECG> <INF4CV>
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "hall_std_if.h"
#include "VehicleSrvClient.h"
#include "AppHmi_TunerStateMachine.h"
//#include "TunerDataPoolConfig.h"
#include "../../datapool/TunerDataPoolConfig.h"
#include "../SourceChangeHandler/SrcChangeHandler.h"
#include "App/Core/Tuner_Defines.h"
#include "DabInfo.h"
#include "AMFMInfo.h"
#include <vector>
#include <string>


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_TUNER_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_TUNER
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_Tuner_"
#define ETG_I_FILE_PREFIX                 App::Core::VehicleSrvClient::
#include "trcGenProj/Header/VehicleSrvClient.cpp.trc.h"
#endif


using namespace ::vehicle_main_fi_types;
using namespace ::VEHICLE_MAIN_FI;
/* using namespace ::datacollector_main_fi;
using namespace ::datacollector_main_fi_types; */


namespace App {
namespace Core {
/**
 * @Constructor
 */
VehicleSrvClient* VehicleSrvClient::_VehicleSrvClient = NULL;
VehicleSrvClient::VehicleSrvClient(): _vehicleProxy(::VEHICLE_MAIN_FIProxy::createProxy("vehicleMainFiPort", *this))
{
   ETG_TRACE_USR4(("VehicleSrvClient Constructor is called"));
   if (_vehicleProxy)
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _vehicleProxy->getPortName());
      ETG_TRACE_USR4(("VehicleSrvClient Constructor after creating proxy"));
   }
   readLanguageOnStartUp();
}


/**
* @Destructor
*/

VehicleSrvClient::~VehicleSrvClient()
{
   ETG_TRACE_USR4(("VehicleSrvClient destructor is called"));
}


struct LanguageTable
{
   int LangIndex;
   std::string LangString;
};


#ifndef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
LanguageTable LanguageMappingTable[LANGNO] =
{
   { 12, "en_GB" },
   { 23, "de_DE" },
   { 10, "nl_NL" },
   { 21, "fr_FR" },
   { 29, "it_IT" },
   { 46, "es_SP" },
   { 39, "pt_PT" },
   { 27, "hu_HU" },
   { 42, "ru_RU" },
   { 8, "cs_CS" },
   { 9, "da_DA" },
   { 35, "nb_NB" },
   { 38, "pl_PL" },
   { 49, "sv_SE" },
   { 47, "es_LA" },
   { 13, "en_US" },
   { 24, "el_GR" },
   { 52, "tr_TR" },
   { 22, "fr_CA" }
};


#endif

#ifdef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
LanguageTable LanguageMappingTable[LANGNO] =
{
   { 12, "en_GB" },
   { 23, "de_DE" },
   { 10, "nl_NL" },
   { 21, "fr_FR" },
   { 29, "it_IT" },
   { 46, "es_ES" },
   { 39, "pt_PT" },
   { 27, "hu_HU" },
   { 8, "cs_CZ" },
   { 9, "da_DK" },
   { 35, "nb_NO" },
   { 38, "pl_PL" },
   { 49, "sv_SE" },
   { 47, "es_LA" },
   { 24, "el_GR" },
   { 52, "tr_TR" },
   { 3, "bg_BG" },
   { 45, "sl_SI" },
   { 44, "sk_SK" },
   { 41, "ro_RO" },
   { 19, "fi_FI" },
   { 7, "hr_HR" }
};


#endif

/**
 * @onAvailable
 */
void VehicleSrvClient::onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   StartupSync::getInstance().onAvailable(proxy, stateChange);
   ETG_TRACE_USR4(("VehicleSrvClient onAvailable is called"));

   _vehicleProxy->sendLanguageUpReg(*this);
   _vehicleProxy->sendTrackCommandUpReg(*this);
   _vehicleProxy->sendTunerCommandUpReg(*this);
   _vehicleProxy->sendTACommandUpReg(*this);
   _vehicleProxy->sendRDSCommandUpReg(*this);
   _vehicleProxy->sendSourceCommandUpReg(*this);
   _vehicleProxy->sendCabinMediaTrackCommandUpReg(*this);
   _vehicleProxy->sendCabinMediaTunerCommandUpReg(*this);
   _vehicleProxy->sendCabinMediaSourceCommandUpReg(*this);
}


/**
 * @onUnavailable
 */
void VehicleSrvClient::onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   StartupSync::getInstance().onUnavailable(proxy, stateChange);
   ETG_TRACE_USR4(("VehicleSrvClient onAvailable is called"));
   _vehicleProxy->sendLanguageRelUpRegAll();
   _vehicleProxy->sendTrackCommandRelUpRegAll();
   _vehicleProxy->sendTunerCommandRelUpRegAll();
   _vehicleProxy->sendTACommandRelUpRegAll();
   _vehicleProxy->sendRDSCommandRelUpRegAll();
   _vehicleProxy->sendSourceCommandRelUpRegAll();
   _vehicleProxy->sendCabinMediaTrackCommandRelUpRegAll();
   _vehicleProxy->sendCabinMediaTunerCommandRelUpRegAll();
   _vehicleProxy->sendCabinMediaSourceCommandRelUpRegAll();
}


void VehicleSrvClient::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("VehicleSrvClient register property is called"));
   if (_vehicleProxy && (proxy == _vehicleProxy))
   {
      ETG_TRACE_USR4(("VehicleSrvClient register property is called"));
      _vehicleProxy->sendLanguageUpReg(*this);
   }
}


void VehicleSrvClient::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("VehicleSrvClient deregister property is called"));
   if (_vehicleProxy && (proxy == _vehicleProxy))
   {
      _vehicleProxy->sendLanguageRelUpRegAll();
      _vehicleProxy->sendTrackCommandRelUpRegAll();
      _vehicleProxy->sendTunerCommandRelUpRegAll();
      _vehicleProxy->sendTACommandRelUpRegAll();
      _vehicleProxy->sendRDSCommandRelUpRegAll();
      _vehicleProxy->sendSourceCommandRelUpRegAll();
      _vehicleProxy->sendCabinMediaTrackCommandRelUpRegAll();
      _vehicleProxy->sendCabinMediaTunerCommandRelUpRegAll();
      _vehicleProxy->sendCabinMediaSourceCommandRelUpRegAll();
   }
}


/*
 * onSetLanguageResult - ASF framework callback which is after SetLanguage
 * @param[in] proxy
 * @param[in] result
 * @param[out] None
 * @return void
 */
void VehicleSrvClient::onSetLanguageResult(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/,  const ::boost::shared_ptr< SetLanguageResult >& result)
{
   ETG_TRACE_USR4(("onSetLanguageResult received :  %d", result->getResult()));
}


/*
 * onSetLanguageError - ASF framework callback which is after SetLanguage
 * @param[in] proxy
 * @param[in] error
 * @param[out] None
 * @return void
 */
void VehicleSrvClient::onSetLanguageError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< SetLanguageError >& /*error*/)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onSetLanguageError"));
}


/*
 * onLanguageStatus - ASF framework callback which is triggered on every setLanguage()
 * @param[in] proxy
 * @param[in] status
 * @param[out] None
 * @return voidl
 * todo :check As of now, after setLanguage, onLanguageStatus() is received twice from the VD_Vehicle data.
 * First update represents, previously configured Language ID and the second one represents currently configured ID.*/

void VehicleSrvClient::onLanguageStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::LanguageStatus >& status)
{
   std::vector<T_Language_SourceTable> langTable = status->getLangTable();
   uint8 langIndex = status->getLanguage();
   ETG_TRACE_USR4(("onLanguageStatus langIndex=%d", langIndex));
   std::string textid = getLanguageId(langIndex);
   //COURIER_MESSAGE_NEW(Courier::SetCultureReqMsg)(Courier::ItemId(textid.c_str()))->Post();
   TunerDataPoolConfig::getInstance()->setLanguage(langIndex);
}


std::string VehicleSrvClient::getLanguageId(int index)
{
   std::string langId = "";
   for (int i = 0; i < (sizeof(LanguageMappingTable) / sizeof(LanguageMappingTable[0])); i++)
   {
      if (LanguageMappingTable[i].LangIndex == index)
      {
         ETG_TRACE_USR4(("onLanguageStatus Language string=%s", LanguageMappingTable[i].LangString.c_str()));
         langId = LanguageMappingTable[i].LangString.c_str();
      }
   }
   return langId;
}


/**
* Description     : This method will be called on system startup for language translation
*
* @return         : uint8
*/
void VehicleSrvClient::readLanguageOnStartUp()
{
   uint8 languageIndex = TunerDataPoolConfig::getInstance()->getLanguage();
   ETG_TRACE_USR4(("TunerHall::setLanguageOnSystemLoad requested :%d", languageIndex));
   std::string textid = getLanguageId(languageIndex);
   //COURIER_MESSAGE_NEW(Courier::SetCultureReqMsg)(Courier::ItemId(textid.c_str()))->Post();
}


/*
 * onLanguageError - ASF framework callback which is triggered if there is any error in setLanguage()
 * @param[in] proxy
 * @param[in] error
 * @param[out] None
 * @return void
 */
void VehicleSrvClient::onLanguageError(const ::boost::shared_ptr< VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< LanguageError >& /*error*/)
{
   ETG_TRACE_USR4(("onLanguageError"));
}


void VehicleSrvClient::onTrackCommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::TrackCommandError >& /*error*/)
{
   ETG_TRACE_COMP(("VehicleSrvClient::onTrackCommandError"));
}


void VehicleSrvClient::onTrackCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::TrackCommandStatus >& status)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onTrackCommandStatus next or prev value  = %d", status->getTrackCommandValue()));
   uint8 bandinfo = SrcChangeHandler::poGetInstance()->getsourceInfo();
   if (bandinfo == 2)
   {
      DabInfo::poGetInstance()->onTunerTrackCommandReq(status->getTrackCommandValue());
   }
}


void VehicleSrvClient::onTunerCommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::TunerCommandError >& /*error*/)
{
   ETG_TRACE_COMP(("VehicleSrvClient::onTunerCommandError"));
}


void VehicleSrvClient::onTunerCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::TunerCommandStatus >& status)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onTunerCommandStatus TunerCmdvalue  = %d", status->getTunerCommandValue()));
   AMFMInfo::poGetInstance()->onTunerCommandReq(status->getTunerCommandValue());
}


void VehicleSrvClient::onTACommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::TACommandError >& /*error*/)
{
   ETG_TRACE_COMP(("VehicleSrvClient::onTACommandError"));
}


void VehicleSrvClient::onTACommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::TACommandStatus >& status)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onTACommandStatus TACmdvalue  = %d", status->getTACommandValue()));
   AMFMInfo::poGetInstance()->onTACommandReq(status->getTACommandValue());
}


void VehicleSrvClient::onRDSCommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::RDSCommandError >& /*error*/)
{
   ETG_TRACE_COMP(("VehicleSrvClient::onRDSCommandError"));
}


void VehicleSrvClient::onRDSCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::RDSCommandStatus >& status)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onRDSCommandStatus RDSCmdvalue  = %d", status->getRDSCommandValue()));
   AMFMInfo::poGetInstance()->onRDSCommandReq(status->getRDSCommandValue());
}


void VehicleSrvClient::onDeviceStatusDABAvailStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusDABAvailStatusError >& error)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onDeviceStatusDABAvailStatusError"));
}


void VehicleSrvClient::onDeviceStatusDABAvailStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusDABAvailStatusResult >& result)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onDeviceStatusDABAvailStatusResult"));
}


void VehicleSrvClient::onMediaStatusDABFMStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusDABFMStatusError >& error)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onMediaStatusDABFMStatusError"));
}


void VehicleSrvClient::onMediaStatusDABFMStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusDABFMStatusResult >& result)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onMediaStatusDABFMStatusResult"));
}


void VehicleSrvClient::onMediaStatusRDSStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusRDSStatusError >& error)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onMediaStatusRDSStatusError"));
}


void VehicleSrvClient::onMediaStatusRDSStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusRDSStatusResult >& result)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onMediaStatusRDSStatusResult"));
}


void VehicleSrvClient::onMediaStatusTAStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusTAStatusError >& error)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onMediaStatusTAStatusError"));
}


void VehicleSrvClient::onMediaStatusTAStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusTAStatusResult >& result)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onMediaStatusTAStatusResult"));
}


void VehicleSrvClient::onMediaStatusTPStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusTPStatusError >& error)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onMediaStatusTPStatusError"));
}


void VehicleSrvClient::onMediaStatusTPStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusTPStatusResult >& result)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onMediaStatusTPStatusResult"));
}


void VehicleSrvClient::onMediaStatusTunerBandStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusTunerBandStatusError >& error)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onMediaStatusTunerBandStatusError"));
}


void VehicleSrvClient::onMediaStatusTunerBandStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusTunerBandStatusResult >& result)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onMediaStatusTunerBandStatusResult"));
}


void VehicleSrvClient::onCabinMediaStatusTunerBandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CabinMediaStatusTunerBandError >& error)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onCabinMediaStatusTunerBandError"));
}


void VehicleSrvClient::onCabinMediaStatusTunerBandResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CabinMediaStatusTunerBandResult >& result)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onCabinMediaStatusTunerBandResult"));
}


void VehicleSrvClient::onMediaStatusTunerPresetStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusTunerPresetStatusError >& error)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onMediaStatusTunerPresetStatusError"));
}


void VehicleSrvClient::onMediaStatusTunerPresetStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusTunerPresetStatusResult >& result)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onMediaStatusTunerPresetStatusResult"));
}


void VehicleSrvClient::onDeviceStatusAMFMAvailError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusAMFMAvailError >& error)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onDeviceStatusAMFMAvailStatusError"));
}


void VehicleSrvClient::onDeviceStatusAMFMAvailResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::DeviceStatusAMFMAvailResult >& result)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onDeviceStatusAMFMAvailStatusResult"));
}


void VehicleSrvClient::updateTAStatus(int taStatus)
{
   ETG_TRACE_USR4(("VehicleSrvClient::updateTAStatus: taStatus : %d", taStatus));
   if (_vehicleProxy != NULL)
   {
      _vehicleProxy->sendMediaStatusTAStatusStart(*this, taStatus);
   }
   else
   {
      ETG_TRACE_USR4(("VehicleSrvClient::updateTAStatus:_vehicleProxy is NULL"));
   }
}


void VehicleSrvClient::updateRDSStatus(int rdsStatus)
{
   ETG_TRACE_USR4(("VehicleSrvClient::updateRDSStatus: rdsStatus : %d", rdsStatus));
   if (_vehicleProxy != NULL)
   {
      _vehicleProxy->sendMediaStatusRDSStatusStart(*this, rdsStatus);
   }
   else
   {
      ETG_TRACE_USR4(("VehicleSrvClient::updateRDSStatus:_vehicleProxy is NULL"));
   }
}


void VehicleSrvClient::updateTPStatus(int tpStatus)
{
   ETG_TRACE_USR4(("VehicleSrvClient::updateTPStatus: tpStatus : %d", tpStatus));
   if (_vehicleProxy != NULL)
   {
      _vehicleProxy->sendMediaStatusTPStatusStart(*this, tpStatus);
   }
   else
   {
      ETG_TRACE_USR4(("VehicleSrvClient::updateTPStatus:_vehicleProxy is NULL"));
   }
}


void VehicleSrvClient::updateDABFMStatus(int dabfmStatus)
{
   ETG_TRACE_USR4(("VehicleSrvClient::updateDABFMStatus: dabfmStatus : %d", dabfmStatus));
   if (_vehicleProxy != NULL)
   {
      _vehicleProxy->sendMediaStatusDABFMStatusStart(*this, dabfmStatus);
   }
   else
   {
      ETG_TRACE_USR4(("VehicleSrvClient::updateDABFMStatus:_vehicleProxy is NULL"));
   }
}


void VehicleSrvClient::updateDABAvailStatus(int dabStatus)
{
   ETG_TRACE_USR4(("VehicleSrvClient::updateDABAvailStatus: dabStatus : %d", dabStatus));
   if (_vehicleProxy != NULL)
   {
      _vehicleProxy->sendDeviceStatusDABAvailStatusStart(*this, dabStatus);
   }
   else
   {
      ETG_TRACE_USR4(("VehicleSrvClient::updateDABAvailStatus:_vehicleProxy is NULL"));
   }
}


void VehicleSrvClient::updateTunerPresetStatus(int presetId)
{
   ETG_TRACE_USR4(("VehicleSrvClient::updateTunerPresetStatus: presetId : %d", presetId));
   if (_vehicleProxy != NULL)
   {
      _vehicleProxy->sendMediaStatusTunerPresetStatusStart(*this, presetId);
   }
   else
   {
      ETG_TRACE_USR4(("VehicleSrvClient::updateTunerPresetStatus:_vehicleProxy is NULL"));
   }
}


void VehicleSrvClient::updateTunerBandStatus(int bandId)
{
   ETG_TRACE_USR4(("VehicleSrvClient::updateTunerBandStatus: bandId : %d", bandId));
   if (_vehicleProxy != NULL)
   {
      _vehicleProxy->sendMediaStatusTunerBandStatusStart(*this, bandId);
   }
   else
   {
      ETG_TRACE_USR4(("VehicleSrvClient::updateTunerBandStatus:_vehicleProxy is NULL"));
   }
}


void VehicleSrvClient::updateCabinTunerBandStatus(int bandId)
{
   ETG_TRACE_USR4(("VehicleSrvClient::updateCabinTunerBandStatus: bandId : %d", bandId));
   if (_vehicleProxy != NULL)
   {
      _vehicleProxy->sendCabinMediaStatusTunerBandStart(*this, bandId);
   }
   else
   {
      ETG_TRACE_USR4(("VehicleSrvClient::updateCabinTunerBandStatus:_vehicleProxy is NULL"));
   }
}


void VehicleSrvClient::updateAMFMAvailStatus(int amfmStatus)
{
   ETG_TRACE_USR4(("VehicleSrvClient::updateAMFMAvailStatus: amfmStatus : %d", amfmStatus));
   if (_vehicleProxy != NULL)
   {
      _vehicleProxy->sendDeviceStatusAMFMAvailStart(*this, amfmStatus);
   }
   else
   {
      ETG_TRACE_USR4(("VehicleSrvClient::updateAMFMAvailStatus:_vehicleProxy is NULL"));
   }
}


void VehicleSrvClient::onSourceCommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SourceCommandError >& error)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onSourceCommandError"));
}


void VehicleSrvClient::onSourceCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SourceCommandStatus >& Status)
{
   tU8 sourceCommandValue = Status->getSourceCommandValue();
   ETG_TRACE_USR4(("VehicleSrvClient::onSourceCommandStatus sourceCommandValue %d", sourceCommandValue));
   SrcChangeHandler::poGetInstance()->vSourceCommandActivation(sourceCommandValue);
}


void VehicleSrvClient::onCabinMediaTrackCommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CabinMediaTrackCommandError >& /*error*/)
{
   ETG_TRACE_COMP(("VehicleSrvClient::onCabinMediaTrackCommandError"));
}


void VehicleSrvClient::onCabinMediaTrackCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CabinMediaTrackCommandStatus >& status)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onCabinMediaTrackCommandStatus next or prev value  = %d", status->getCabinMediaTrackCommandValue()));
   uint8 bandinfo = SrcChangeHandler::poGetInstance()->getsourceInfo();
   if (bandinfo == 2)
   {
      DabInfo::poGetInstance()->onTunerTrackCommandReq(status->getCabinMediaTrackCommandValue());
   }
}


void VehicleSrvClient::onCabinMediaTunerCommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CabinMediaTunerCommandError >& /*error*/)
{
   ETG_TRACE_COMP(("VehicleSrvClient::onCabinMediaTunerCommandError"));
}


void VehicleSrvClient::onCabinMediaTunerCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CabinMediaTunerCommandStatus >& status)
{
   ETG_TRACE_USR4(("VehicleSrvClient::onCabinMediaTunerCommandStatus TunerCmdvalue  = %d", status->getCabinMediaTunerCommandValue()));
   AMFMInfo::poGetInstance()->onTunerCommandReq(status->getCabinMediaTunerCommandValue());
}


void VehicleSrvClient::onSendMediaInfoError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy  >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendMediaInfoError >& error)
{
   ETG_TRACE_COMP(("VehicleSrvClient::onSendMediaInfoError received"));
}


void VehicleSrvClient::onSendMediaInfoResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy  >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendMediaInfoResult >& result)
{
   ETG_TRACE_COMP(("VehicleSrvClient::onSendMediaInfoResult received"));
}


void VehicleSrvClient::onSendMainlineInfoError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy  >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendMainlineInfoError >& error)
{
   ETG_TRACE_COMP(("VehicleSrvClient::onSendMainlineInfoError received"));
}


void VehicleSrvClient::onSendMainlineInfoResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy  >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendMainlineInfoResult >& result)
{
   ETG_TRACE_COMP(("VehicleSrvClient::onSendMainlineInfoResult received"));
}


void VehicleSrvClient::pushTunerCANLongData(uint8 tunerType, std::string tunerData)
{
   ETG_TRACE_USR4(("VehicleSrvClient::pushTunerCANLongDataToVector: tunerType %d, tunerData %s", tunerType, tunerData.c_str()));
   uint8 tunerDataCurrentIndex = 0;
   ::vehicle_main_fi_types::T_CAN_Mesg  tunerCANmsg;
   _tunerCANLongDataInfo.push_back(tunerType);
   if (!tunerData.empty())
   {
      for (; tunerDataCurrentIndex < tunerData.size(); ++tunerDataCurrentIndex)
      {
         _tunerCANLongDataInfo.push_back(tunerData[tunerDataCurrentIndex]);
      }
   }
   _tunerCANLongDataInfo.push_back('\0');

   tunerCANmsg.setListData(_tunerCANLongDataInfo);
   _tunerCANLongDataInfo.clear();
   if ((tunerType == TUNER_FILENAME) || (tunerType == TUNER_TITLE) || (tunerType == TUNER_FOLDER) || (tunerType == TUNER_ARTIST) || (tunerType == TUNER_ALBUM))
   {
      _vehicleProxy->sendSendMediaInfoStart(*this, tunerCANmsg);
   }
   else if (tunerType == TUNER_MAINLINE)
   {
      _vehicleProxy->sendSendMainlineInfoStart(*this, tunerCANmsg);
   }
   else
   {
      //Do Nothing
   }
}


void VehicleSrvClient::onCabinMediaSourceCommandError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CabinMediaSourceCommandError >& /*error*/)
{
   ETG_TRACE_COMP(("VehicleSrvClient::onCabinMediaSourceCommandError"));
}


void VehicleSrvClient::onCabinMediaSourceCommandStatus(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::CabinMediaSourceCommandStatus >& status)
{
   uint16 cabinMediaSourceCommandValue = status->getCabinMediaSourceCommandValue();
   ETG_TRACE_USR4(("VehicleSrvClient::onCabinMediaSourceCommandStatus cabinMediaSourceCommandValue %d", cabinMediaSourceCommandValue));
   SrcChangeHandler::poGetInstance()->vCabinSourceCommandActivation(cabinMediaSourceCommandValue);
}


}
}
