/************************************************************************
*FILE: 			TunerStdSpecTypes.h
*SW-COMPONENT: 	Tuner
*DESCRIPTION: 	User-defined data types with respect to Standard Specific
*				functionalities
*AUTHOR: 		Preethi Muthu
*COPYRIGHT: 	(c) 2018-2019 Robert Bosch Car Multimedia GmbH
*HISTORY:
*05.03.13 Rev. 1.0 Preethi Muthu
* 		  Initial Revision.
************************************************************************/

#ifndef TUNERSTDSPECTYPES_HEADER
#define TUNERSTDSPECTYPES_HEADER

/*****************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------*/

/*
 * View ID definitions
 */
typedef enum
{
   EN_VIEW_SOURCE_SELECTION,
   EN_VIEW_FM1,
   EN_VIEW_FM2,
   EN_VIEW_FM_AST,
   EN_VIEW_AM,
   EN_VIEW_AM_AST,
   EN_VIEW_OPT_FMAM,
   EN_VIEW_FM_TESTMODE,
   EN_VIEW_FM_MONITORTESTMODE,
   EN_VIEW_AM_TESTMODE,
   EN_VIEW_AM_MONITORTESTMODE,
   EN_VIEW_SOURCE_SELECTION_woNAV,
   EN_VIEW_FM_SL,
   EN_VIEW_DAB,
   EN_VIEW_DAB_AST,
   EN_VIEW_DAB_SL,
   EN_VIEW_OPT_DABPTY,
   EN_VIEW_DAB_MONITOR = 22,
   EN_VIEW_TT_MONITOR1 = 23,
   EN_VIEW_TT_MONITOR2,
   EN_VIEW_TT_MONITOR3,
   EN_VIEW_DAB_SETUP_MONITOR,
   EN_VIEW_DAB_QUALITY_TESTMODE,
   EN_VIEW_DAB_SERVICE_INFO_TESTMODE,
   EN_VIEW_DAB_EXPERT_API_TESTMODE,
   EN_VIEW_AF_LIST,
   EN_VIEW_TMC,
   EN_VIEW_TMC_LIST,
   EN_VIEW_TMC_INFO,
   EN_VIEW_TMC_STN_INFO,
   EN_VIEW_TESTMODESCREENS,
   EN_VIEW_MASTER_GADGET_TUNER = 38,
   EN_VIEW_WEATHERBAND = 39,
   EN_VIEW_FM_INFO = 40,
   EN_VIEW_AM_INFO = 41,
   EN_VIEW_HDDTM_TESTMODE = 42,
   EN_VIEW_HDPARAMTUNING_TESTMODE = 43,
   EN_VIEW_WEATHERBAND_MONITOR = 44,
   EN_NUM_VIEWS,
   EN_VIEW_PLAYVIEW = 253,
   EN_VIEW_PREVIOUS = 254,
   EN_TUNER_VIEW_INVALID = 255
} tenViewID;

/* Audio levels in different tuner types */
typedef enum
{
   EN_AUDIO_FM = 0,
   EN_AUDIO_DAB = 2,
   EN_AUDIO_MW = 1,
   EN_AUDIO_LW = 3
} tenAudio;

typedef enum
{
   EN_AM_SOURCE = 0,
   EN_FM_SOURCE = 1,
   EN_DAB_SOURCE = 2,
   EN_DRM_SOURCE = 3,
   EN_SPI_SOURCE = 4,
   EN_OTHER_SOURCE = 5
} tenSource;

typedef enum
{
   EN_TUN_BANK_INVALID = 0,
   EN_TUN_BANK_FM1,
   EN_TUN_BANK_FM2,
   EN_TUN_BANK_FM_AST,
   EN_TUN_BANK_AM,
   EN_TUN_BANK_AM_AST,
   EN_TUN_BANK_DAB,
   EN_TUN_BANK_DAB_AST,
   EN_TUN_BANK_WX = 18
} tenTunBank;

enum
{
   TUN_PRESET_BANK_FM1 = 0,
   TUN_PRESET_BANK_FM2,
   TUN_PRESET_BANK_FM3,
   TUN_PRESET_BANK_FMAST,
   TUN_PRESET_BANK_AM_MW1,
   TUN_PRESET_BANK_AM_MW2,
   TUN_PRESET_BANK_AM_MW3,
   TUN_PRESET_BANK_AM_MWAST,
   TUN_PRESET_BANK_AM_LW1,
   TUN_PRESET_BANK_AM_LW2,
   TUN_PRESET_BANK_AM_LW3,
   TUN_PRESET_BANK_AM_LWAST,
   TUN_PRESET_BANK_AM_AST,
   TUN_PRESET_BANK_DAB1,
   TUN_PRESET_BANK_DAB2,
   TUN_PRESET_BANK_DAB3,
   TUN_PRESET_BANK_DABAST,
   TUN_PRESET_BANK_MIX1,
   TUN_PRESET_BANK_MIX2,
   TUN_PRESET_BANK_MIX3,
   TUN_PRESET_BANK_MIX_AST,
   TUN_PRESET_BANK_DRM1,
   TUN_PRESET_BANK_DRM_AST
};


enum
{
   EN_POPUP_DISPLAY = 0,
   EN_POPUP_HIDE,
   EN_POPUP_CANNOTSTORE
};


enum
{
   EV_MSG_TO_PL_TA = 1,
   EV_MSG_TO_PL_RADIO_TEXT,
   EV_MSG_TO_PL_REGPGM,
   EV_MSG_TO_PL_ALT_FREQ,
   EV_MSG_TO_PL_TP,
   EV_MSG_TO_PL_PTY31,
   EV_MSG_TO_PL_HICUTABS_STATUS,
   EV_MSG_TO_PL_SHARXABS_STATUS,
   EV_MSG_TO_PL_MEASUREMODE_STATUS,
   EV_MSG_TO_PL_OPT_TA ,
   EV_MSG_TO_PL_OPT_RADIO_TEXT,
   EV_MSG_TO_PL_OPT_REGPGM,
   EV_MSG_TO_PL_OPT_ALT_FREQ,
   EV_MSG_TO_PL_MUTE,
   EV_MSG_TO_PL_RDS_CONFIG,
   EV_MSG_TO_PL_AF_CONFIG,
   EV_MSG_TO_PL_REG_CONFIG,
   EV_MSG_TO_PL_TA_CONFIG,
   EV_MSG_TO_PL_NAVI_CONFIG,
   EV_MSG_TO_PL_AM_SLIDER_RANGE,
   EV_MSG_TO_PL_AM_SLIDER_STEPSIZE,
   EV_MSG_TO_PL_AM_SLIDERNOOFSTEPS,
   EV_MSG_TO_PL_AM_SLIDER_MAXVALUE,
   EV_MSG_TO_PL_AM_SLIDER_MINVALUE,
   EV_MSG_TO_PL_FM_SLIDER_STEPSIZE,
   EV_MSG_TO_PL_FM_SLIDERNOOFSTEPS,
   EV_MSG_TO_PL_FM_SLIDER_MAXVALUE,
   EV_MSG_TO_PL_TA_ICON,
   EV_MSG_TO_PL_VARIANT_TYPE,
   EV_MSG_TO_PL_SEL_ELEM,
   EV_MSG_TO_PL_DABUPDATE_POPUP,
   EV_MSG_TO_PL_TA_PSNAME,
   EV_MSG_TO_PL_SOURCE_SEL_ICON,
   EV_MSG_TO_PL_AUTOSTORE,
   EV_MSG_TO_PL_OPT_DAB_DYNCONTENT,
   EV_MSG_TO_PL_OPT_DAB_FM_LINKING,
   EV_MSG_TO_PL_OPT_DAB_DAB_LINKING,
   EV_MSG_TO_PL_DABPTY_FILTER_SETTINGS,
   EV_MSG_TO_PL_LINEAR_AUDIO,
   EV_MSG_TO_PL_AUTOSTORE_POPUP,
   EV_MSG_TO_PL_SPI_ICON,
   EV_MSG_TO_PL_TP_CURRENT_STATION,
   EV_MSG_TO_PL_TA_ICON_TYPE,
   EV_MSG_TO_PL_PHASEDIVERSITY
};


//
typedef enum
{
   EN_DAB_ALL_OK = 0,
   EN_DAB_FM_LINK,
   EN_DAB_SECOND_AUDIO,
   EN_DAB_LOADING,
   EN_DAB_NO_RECEPTION
} tenDabStatus;

//wst4kor--->advisory_text
typedef enum
{
   EN_HD_ALL_OK = 0,
   EN_HD_SIGNAL_LOST,
   EN_HD_SIGNAL_WAIT,
   EN_HD_NO_CHANNEL,
   EN_HD_AVAILABLE
} HdAdvisory;
//
enum
{
   EN_VARIANT_TYPE_INVALID = 0,
   EN_VARIANT_TYPE_EU,
   EN_VARIANT_TYPE_GEX,
   EN_VARIANT_TYPE_CHINA
};


//
//enum
//{
//   EN_HW_TYPE_NA = 0,
//   EN_HW_TYPE_GEX,
//   EN_HW_TYPE_GEX_CN,
//   EN_HW_TYPE_EU,
//   EN_HW_TYPE_EU_DAB
//};
//
//enum
//{
//   EN_NOT_APPLICABLE = 0,
//   EN_AUSTRALIA,
//   EN_CHINA,
//   EN_EUROPE,
//   EN_INDIA,
//   EN_MEXICO,
//   EN_NEWZEALAND,
//   EN_RUSSIA,
//   EN_THAILAND,
//   EN_TURKEY
//};
//
//
//enum
//{
//   EN_NEXT_LEVEL_TRANSITION  = 11,
//   EN_PREVIOUS_LEVEL_TRANSITION,
//   EN_PAGE_FLIPBACK_TRANSITION,
//   EN_PAGE_FLIPFRONT_TRANSITION,
//   EN_ZOOM_IN,
//   EN_ZOOM_OUT
//};
//
enum
{
   EN_OPT_SOUNDSETTINGS = 1,
   EN_CB_RADIO_TEXT,
   EN_CB_TA,
   EN_CB_REGPGM,
   EN_CB_ALTFREQ,
   EN_OPT_DABPTY,
   EN_CB_DAB_DYNCONTENT,
   EN_CB_DAB_FM_FOLLOWING,
   EN_CB_DAB_DAB_LINKING
};


//
typedef enum
{
   EN_PTY_FILTER_ENABLED = 0,
   EN_PTY_TYPE_NEWS,
   EN_PTY_TYPE_CULTURE,
   EN_PTY_TYPE_SPORTS,
   EN_PTY_TYPE_MUSIC,
   EN_PTY_TYPE_SPECIAL
} tenPtyFilter;
//
typedef enum
{
   EN_MENU_TYPE_MAIN = 0,
   EN_MENU_TYPE_DABPTY_FILTER
} tenMenuID;
//
//typedef enum
//{
//   EN_DAB_SETUP_CONCEALMENT,
//   EN_DAB_SETUP_LINKING,
//   EN_DAB_SETUP_ENS_INS_THRESHOLD,
//   EN_DAB_SETUP_ENS_DEL_THRESHOLD,
//   EN_DAB_SETUP_BG_LEARN_UPDATE_TIME,
//   EN_DAB_SETUP_DAB_SCAN_THRESHOLD,
//   EN_DAB_SETUP_MEASUREMENT_MODE,
//   EN_DAB_SETUP_LINKING_SETUP_MASK
//}tenDabSetupParams;
//
///*
// * Has to correspond to midw_ext_fi_tcl_e8_DAB_ServiceLinkingMode::tenType
// */


//enum
//{
//   EN_PRESET_NONE = 0,
//   EN_PRESET_1,
//   EN_PRESET_2,
//   EN_PRESET_3,
//   EN_PRESET_4,
//   EN_PRESET_5,
//   EN_PRESET_6
//};
typedef enum
{
   EN_DAB_LINKING_OFF,
   EN_DAB_LINKING_DAB,
   EN_DAB_LINKING_DAB_FM,
   EN_DAB_LINKING_FM
} tenDabLinkingStatus;
//
typedef enum
{
   EN_TA_SOURCE_NONE,
   EN_TA_SOURCE_FM,
   EN_TA_SOURCE_DAB,
   EN_TA_SOURCE_NODATA,
   EN_TA_SOURCE_NA
} tenTASource;
////sca5kor: Indroduced to identify the different icons to be updated to the HMI
///*https://hi-cmts.apps.intranet.bosch.com:8443/browse/SUZUKI-20807*/
//typedef enum
//{
//   EN_REC_UNSEL = 0,//Receivable and not selected
//   EN_REC_SEL,//Receivable and selected
//   EN_UNREC_UNSEL,//NotReceivable and not selected
//   EN_UNREC_SEL//NotReceivable and selected
//} tenReceptionStatus;
#endif // TUNERSTDSPECTYPES_HEADER

/******************************************************************************
| EOF
|----------------------------------------------------------------------------*/
