/* ***************************************************************************************
* FILE:          TunerGui.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  TunerGui.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "TunerGui.h"
#include "HMI/CGIComponents/AppViewSettings.h"
#include "HMI/CGIComponents/CGIApp.h"
#include "AppBase/IApplicationSettings.h"
#include "Common/AppBaseSettings/KeyMapping.h"


//////// TRACE IF ///////////////////////////////////////////////////
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_TUNER_MAIN
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_TUNER
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_Tuner_"
#define ETG_I_FILE_PREFIX                 App::Core::TunerGui::
#include "trcGenProj/Header/TunerGui.cpp.trc.h"
#endif // VARIANT_S_FTR_ENABLE_TRC_GEN
//////// TRACE IF ///////////////////////////////////////////////////

//                                   main surface,                                      video surface,                    popup surfaces
//DEFAULT_APPSETTINGS(static_cast<int>(SURFACEID_MAIN_SURFACE_TUNER), static_cast<int>(SURFACEID_NONE), static_cast<int>(SURFACEID_TOP_POPUP_SURFACE_TUNER), static_cast<int>(SURFACEID_CENTER_POPUP_SURFACE_TUNER))
//DEFAULT_APPSETTINGS(SURFACEID_MAIN_SURFACE_TUNER,SURFACEID_NONE, SURFACEID_TOP_POPUP_SURFACE_TUNER, SURFACEID_CENTER_POPUP_SURFACE_TUNER)
APPSETTINGS_BEGIN()
APPSETTINGS_ADD_MAINSURFACE(SURFACEID_MAIN_SURFACE_TUNER),
//
                            APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_TOP_POPUP_SURFACE_TUNER),
                            APPSETTINGS_ADD_POPUPSURFACE(SURFACEID_CENTER_POPUP_SURFACE_TUNER)

                            APPSETTINGS_END()

                            using namespace ::hmi;

namespace App {
namespace Core {


TunerGui::TunerGui() : GuiComponentBase(hmi::apps::reference::appHmi_Tuner, appSettings)
{
   ETG_I_REGISTER_FILE();
   ETG_I_REGISTER_CHN(TraceCmd_NotProcessedMsg);
   _hmiAppCtrlProxyHandler.setTraceId(TR_CLASS_APPHMI_TUNER_APPCTRL_PROXY);
   SYNC_BLOCK_CONNECTION(765, TUNER_GADGET);
   //SYNC_BLOCK_CONNECTION(765, TUNER_GADGET_FREQUENCY);
   //SYNC_BLOCK_CONNECTION(765, TUNER_GADGET_MUTE);
   //SYNC_BLOCK_CONNECTION(765, TUNER_GADGET_SEEKMENU);
   uint32 DisplayID_D1 = 1;// DisplayConfiguration::getInstance()->getPhysicalDisplayIdOfDisplayIndex(0);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_MAIN_SURFACE_TUNER, DisplayID_D1);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_TOP_POPUP_SURFACE_TUNER, DisplayID_D1);
   ScreenBrokerClient::SurfaceDisplayMap::registerItem(SURFACEID_CENTER_POPUP_SURFACE_TUNER, DisplayID_D1);
}


TunerGui::~TunerGui()
{
}


unsigned int TunerGui::getDefaultTraceClass()
{
   return TR_CLASS_APPHMI_TUNER_MAIN;
}


void TunerGui::setupCgiInstance()
{
   std::string assetFileName = hmibase::app::base::SystemConfiguration::getAssetFileName();
   setCgiApp(new CGIApp(assetFileName.c_str(), _hmiAppCtrlProxyHandler));
}


void TunerGui::preRun()
{
//   DP_vCreateDatapool();
   PersistentValuesRead();
}


void TunerGui::postRun()
{
   PersistentValuesWrite();
}


void TunerGui::PersistentValuesRead()
{
//   dp_tclhmiAppTunerPersMemVarsTuner dp;
//   _mvar = dp.tGetData();
}


void TunerGui::PersistentValuesWrite()
{
//   dp_tclhmiAppTunerPersMemVarsTuner dp;
//   dp.s32SetData(_mvar);
}


/**
 *sink for not processed ttfis input messages
 */
void TunerGui::TraceCmd_NotProcessedMsg(const unsigned char* data)
{
   if (data)
   {
      ETG_TRACE_FATAL(("TraceCmd_NotProcessedMsg() : 0x%*x", ETG_LIST_LEN(data[0]), ETG_LIST_PTR_T8(data)));
   }
}


} // namespace Core
} // namespace App
